# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define oname sip
%define pkg_version %(echo %version | sed 's/\\./,/g')

%def_with python3

Name: python-module-%oname
Version: 4.19.3
Release: alt0.M80P.1

Summary: Python bindings generator for C++ class libraries

License: PSF
Group: Development/Python
URL: http://www.riverbankcomputing.com/software/sip/

%setup_python_module sip

# hg clone http://www.riverbankcomputing.com/hg/sip
#Source-url: https://pypi.io/packages/source/s/%oname/%oname-%version.tar.gz
# Source-url: https://prdownloads.sourceforge.net/pyqt/sip/sip-%version/sip-%version.tar.gz
Source: %name-%version.tar

Provides: %modulename = %version-%release
Obsoletes: %modulename <= 4.1-alt2.1

#BuildPreReq: gcc-c++
#BuildPreReq: flex
# for docs build
#BuildPreReq: python-module-sphinx-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: elfutils libstdc++-devel python-base python-modules python-modules-compiler python3 python3-base
BuildRequires: flex gcc-c++ python-devel python3-devel rpm-build-python3

#BuildRequires: python3-devel
%endif

%description
Generates Python bindings for C++ class libraries from a set of class
specification files.  Also includes a Python extension module needed by all
generated bindings.

%if_with python3
%package -n python3-module-%oname
Summary: Python 3 bindings generator for C++ class libraries
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
Generates Python bindings for C++ class libraries from a set of class
specification files.  Also includes a Python extension module needed by all
generated bindings.

%package -n python3-module-%oname-devel
Requires: python3-module-%oname = %version-%release
Summary: Header files for sip (Python 3)
Group: Development/Python3
BuildArch: noarch
Requires: python3-devel

%description -n python3-module-%oname-devel
Header files for sip
%endif

%package devel
Requires: %name = %version-%release
Summary: Header files for sip
Group: Development/Python
BuildArch: noarch
Provides: %modulename-devel = %version-%release
%py_package_provides %modulename-devel = %version-%release
Obsoletes: %modulename-devel
Requires: python-devel

%description devel
Header files for sip

%prep
%setup

#rm -f siplib/libsip.a

# fix versions sets
#subst 's/version = (0, 1, 0)/version = (%pkg_version)/' build.py
#python build.py prepare

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
python configure.py --debug -d %python_sitelibdir
sed -i 's|^\(CPPFLAGS.*\)|\1 -g -I%python_includedir|' */Makefile
%make

# docs build
#python build.py doc

%if_with python3
pushd ../python3
python3 configure.py --debug -d %python3_sitelibdir
sed -i \
	's|^\(CPPFLAGS.*\)|\1 -g -I%__python3_includedir|' \
	*/Makefile
sed -i \
	's|lpython%__python3_version|l:%(basename %__libpython3)|' \
	siplib/Makefile
%make
popd
%endif

%install
%if_with python3
pushd ../python3
%makeinstall_std
popd
mv %buildroot%_bindir/sip %buildroot%_bindir/sip3
sed -i 's|%_datadir/sip|%_datadir/sip3|' \
	%buildroot%python3_sitelibdir/sipconfig.py
sed -i 's|%_bindir/sip|%_bindir/sip3|' \
	%buildroot%python3_sitelibdir/sipconfig.py
%endif
%makeinstall_std

%files
%_bindir/*
%exclude %_bindir/sip3
%python_sitelibdir/*
%doc README NEWS LICENSE*

%files devel
%python_includedir/*
#doc doc/*

%if_with python3
%files -n python3-module-%oname
%doc README NEWS LICENSE*
%_bindir/sip3
%python3_sitelibdir/*

%files -n python3-module-%oname-devel
# Here, we just use the same path as in the build system:
%__python3_includedir/*
#doc doc/*
%endif

%changelog
