%define oname six
%def_with check

%def_with python3

Name: python-module-%oname
Version: 1.10.0
Release: alt7
Summary: Python 2 and 3 compatibility utilities
License: MIT
Group: Development/Python
Url: http://pypi.python.org/pypi/six
# Url: https://github.com/benjaminp/six
Packager: Python Development Team <python at packages.altlinux.org>

Source: %name-%version.tar
Source2: move.list
BuildArch: noarch

%define move_list %(echo `cat %{SOURCE2}`)

%py_provides %move_list

BuildPreReq: python-devel
# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: python-module-setuptools-tests}}
BuildRequires: python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%{?!_without_check:%{?!_disable_check:BuildRequires: python3-module-setuptools-tests}}
BuildRequires: python3-module-setuptools
%endif

%description
Six is a Python 2 and 3 compatibility library. It provides utility
functions for smoothing over the differences between the Python versions
with the goal of writing Python code that is compatible on both Python
versions. See the documentation for more information on what is
provided.

%package -n python3-module-%oname
Summary: Python 2 and 3 compatibility utilities
Group: Development/Python3
%py3_provides %move_list

%description -n python3-module-%oname
Six is a Python 2 and 3 compatibility library. It provides utility
functions for smoothing over the differences between the Python versions
with the goal of writing Python code that is compatible on both Python
versions. See the documentation for more information on what is
provided.

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build_debug
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
#py.test -vv
%if_with python3
pushd ../python3
python3 setup.py test
#py.test-%_python3_version -vv
popd
%endif

%files
%doc README documentation/*.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc README documentation/*.rst
%python3_sitelibdir/*
%endif

%changelog
