%define version 1.0.2
%define release alt1
%define oname south
%setup_python_module %oname
%add_python_req_skip cx_Oracle

%def_with python3

Name: python-module-%oname
Version:%version
Release: alt1.1.1
BuildArch: noarch

Summary: Migrations for Django
License: Apache
Group: Development/Python
Url: http://south.aeracode.org

# Source: http://www.aeracode.org/releases/south/%modulename-%version.tar.gz
# https://bitbucket.org/andrewgodwin/south/overview
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-psycopg2 python-module-pytest python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-module-yaml python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-multiprocessing python-modules-unittest python-modules-wsgiref python3 python3-base python3-module-psycopg2 python3-module-pytest python3-module-setuptools python3-module-yaml
BuildRequires: python-module-alabaster python-module-django python-module-docutils python-module-html5lib python-module-objects.inv python-module-setuptools-tests python3-module-django python3-module-setuptools-tests rpm-build-python3 time

#BuildPreReq: python-module-sphinx-devel python-module-setuptools-tests
#BuildPreReq: python-module-django
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-django
%endif

%description
South is an intelligent database migrations library for the Django web framework.
It is database-independent and DVCS-friendly, as well as a whole host of other features.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
South is an intelligent database migrations library for the Django web framework.
It is database-independent and DVCS-friendly, as well as a whole host of other features.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
South is an intelligent database migrations library for the Django web framework.
It is database-independent and DVCS-friendly, as well as a whole host of other features.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
South is an intelligent database migrations library for the Django web framework.
It is database-independent and DVCS-friendly, as well as a whole host of other features.

This package contains documentation for %oname.

%package -n python3-module-%oname
Summary: Migrations for Django
Group: Development/Python3
%add_python3_req_skip cx_Oracle

%description -n python3-module-%oname
South is an intelligent database migrations library for the Django web framework.
It is database-independent and DVCS-friendly, as well as a whole host of other features.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
South is an intelligent database migrations library for the Django web framework.
It is database-independent and DVCS-friendly, as well as a whole host of other features.

This package contains tests for %oname.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc AUTHORS README
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle
%exclude %python_sitelibdir/*/test*
%exclude %python_sitelibdir/*/*/*/test*

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%files tests
%python_sitelibdir/*/test*
%python_sitelibdir/*/*/*/test*

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS README
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test*
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*
%exclude %python3_sitelibdir/*/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/test*
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*
%python3_sitelibdir/*/*/*/*/test*
%endif

%changelog
