%define oname sphinx

%def_with python3

%define sphinx_dir %python_sitelibdir_noarch/%oname
%if_with python3
%define sphinx3_dir %python3_sitelibdir_noarch/%oname
%endif

Name: python-module-%oname
Version: 1.4
Release: alt8.a0.git20150813
Epoch: 1

Summary: Tool for producing documentation for Python projects
License: BSD
Group: Development/Python
Url: http://sphinx.pocoo.org/
Packager: Python Development Team <python@packages.altlinux.org>

%py_requires simplejson

Provides: python-module-objects.inv
Obsoletes: python-module-objects.inv

# https://github.com/sphinx-doc/sphinx.git
Source0: %name-%version.tar
Source1: conf.py.template
Source2: macro
Source3: macro3
Source4: refcounting.py
Patch0: sphinx-1.4b1-alt-avoid-download-objects.inv.patch 

BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildRequires: python-sphinx-objects.inv
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytz python-module-setuptools python-module-simplejson python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python-modules-xml python-tools-2to3 python3 python3-base python3-module-Pygments python3-module-babel python3-module-cssselect python3-module-docutils python3-module-genshi python3-module-jinja2 python3-module-pytz python3-module-setuptools python3-module-snowballstemmer
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-nose time

#BuildRequires: python-devel python-module-setuptools python-module-simplejson
# for docs
#BuildRequires: texlive-latex-extra 
#BuildRequires: python-module-Pygments
#BuildRequires: python-module-docutils python-module-jinja2 texlive-latex-base
# for tests
#BuildRequires:  python-module-nose python-modules-json
#BuildRequires: python-module-snowballstemmer python-module-babel
#BuildRequires: python-module-alabaster python-module-sphinx_rtd_theme
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-html5lib python3-module-nose
#BuildRequires: python3-devel python3-module-distribute
#BuildRequires: python3-module-Pygments python3-module-docutils
#BuildRequires: python3-module-jinja2 python3-module-nose
#BuildRequires: python-tools-2to3 python3-module-jinja2-tests
#BuildRequires: python3-module-snowballstemmer python3-module-babel
#BuildRequires: python3-module-alabaster python3-module-sphinx_rtd_theme

# For python3-2to3:
BuildPreReq: python3-tools
%endif

# For %%check:
BuildPreReq: %py_dependencies mock
# minimal deps on the built-in sqlite driver have been fixed in 1.0.8-alt2:
BuildPreReq: python-module-SQLAlchemy >= 1.0.8-alt2
%if_with python3
BuildPreReq: python3(mock) python3(docutils) python3(jinja2) python3(pygments)
BuildPreReq: python3-module-SQLAlchemy >= 1.0.8-alt2
%endif

%description
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%if_with python3
%package -n python3-module-%oname
Summary: Tool for producing documentation for Python 3 projects
Group: Development/Python3
%add_python3_req_skip xapian
Provides: python3-module-objects.inv
Obsoletes: python3-module-objects.inv

%description -n python3-module-%oname
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%package -n python3-module-%oname-devel
Summary: Development package for Sphinx (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %epoch:%version-%release
#Requires: python3-module-%oname-pickles = %epoch:%version-%release
Requires: python3-module-%oname-tests
Requires: rpm-macros-sphinx3 = %epoch:%version-%release
Requires: python3-module-jinja2-tests

%description -n python3-module-%oname-devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package -n python3-module-%oname-pickles
Summary: Pickles for Sphinx (Python 3)
Group: Development/Python3

%description -n python3-module-%oname-pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.

%package -n python3-module-%oname-tests
Summary: Tests for Sphinx (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %epoch:%version-%release
%py3_requires nose
%add_python3_req_skip compiler
%add_python3_req_skip missing_module missing_package1 missing_package2
%add_python3_req_skip missing_package3 typing

%description -n python3-module-%oname-tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%package -n rpm-macros-sphinx3
Summary: RPM macros for build with Sphinx (Python 3)
Group: Development/Python3
#Requires: rpm-build-python3
#Requires: python3-module-%oname = %epoch:%version-%release

# W.r.t. to the content of the macros (see the substitution in %%install):
#Requires: %sphinx3_dir
# ...but -- see the comment for rpm-macros-sphinx.

%description -n rpm-macros-sphinx3
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.
%endif

%package devel
Summary: Development package for Sphinx
Group: Development/Python
Requires: %name = %epoch:%version-%release
Requires: %name-pickles = %epoch:%version-%release
Requires: rpm-macros-sphinx = %epoch:%version-%release

%description devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package -n rpm-macros-sphinx
Summary: RPM macros for build with Sphinx
Group: Development/Python
#Requires: rpm-build-python

# W.r.t. to the content of the macros (see the substitution in %%install):
#Requires: %sphinx_dir
# ...but we do not add such a formal dependency,
# because it is not needed at all
# given the intended usage of rpm-macros-* packages.
# The guarantee that a macro doesn't refer to a path other
# than the current valid %%sphinx_dir
# is given by the strict dep of the main pkg (on EVR of the macros pkg).

%description -n rpm-macros-sphinx
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.

%package tests
Summary: Tests for Sphinx
Group: Development/Python
Requires: %name = %epoch:%version-%release
%py_requires nose
%add_python_req_skip compiler
%add_python_req_skip missing_module missing_package1 missing_package2
%add_python_req_skip missing_package3
%add_findreq_skiplist %sphinx_dir/tests/typing_test_data.py

%description tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%package doc
Summary: Documentation for Sphinx
Group: Development/Python

%description doc
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package contains documentation for Sphinx itself.

%package pickles
Summary: Pickles for Sphinx
Group: Development/Python

%description pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.

%prep
%setup
%patch0 -p1
install -pm644 %_sourcedir/conf.py.template .

ln -s %_datadir/python-sphinx/objects.inv doc/
ln -s %_datadir/python-sphinx/objects.inv tests/

cp %SOURCE4 sphinx/ext/

%if_with python3
rm -rf ../python3
cp -a . ../python3
install -pm644 %_sourcedir/macro3 ../python3/
%endif

install -pm644 %_sourcedir/macro .

%build
%python_build

%if_with python3
pushd ../python3

python3-2to3 -w -n tests/etree13/HTMLTreeBuilder.py
sed -i 's|python|python3|' doc/Makefile
sed -i 's|mimetools|email|g' tests/etree13/HTMLTreeBuilder.py
sed -i 's|%_bindir/python|%_bindir/python3|' tests/coverage.py
sed -i 's|%_bindir/env python|%_bindir/env python3|' \
	tests/path.py tests/run.py

#cp -R tests %oname/
#for i in $(find %oname/tests -type d)
#do
#	touch $i/__init__.py
#done

%python3_build

popd
%endif

# docs

%make_build -C doc html
%make_build -C doc man

%install
%if_with python3
pushd ../python3
%python3_install

cp -R tests %buildroot%sphinx3_dir/
for i in $(find %buildroot%sphinx3_dir/tests -type d)
do
	touch $i/__init__.py
done

ln -rs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx3_dir/
# There is some objects.inv there already; probably, we want to update it:
ln -frs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx3_dir/tests/

popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i py3_$i
done
popd
%endif

%python_install

# tests

cp -R tests %buildroot%sphinx_dir/
for i in $(find %buildroot%sphinx_dir/tests -type d)
do
	touch $i/__init__.py
done

ln -rs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx_dir/
# There is some objects.inv there already; probably, we want to update it:
ln -frs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx_dir/tests/

# docs

install -d %buildroot%_docdir/%name
#install -d %buildroot%_docdir/%name/pdf
install -d %buildroot%_man1dir

cp -R doc/_build/html %buildroot%_docdir/%name/
#install -p -m644 doc/_build/latex/*.pdf %buildroot%_docdir/%name/pdf
install -p -m644 AUTHORS CHANGES* EXAMPLES LICENSE README.rst \
	%buildroot%_docdir/%name
#install -p -m644 doc/_build/man/*.1 %buildroot%_man1dir

# macros

install -d %buildroot%_rpmmacrosdir
sed -e 's:@SPHINX_DIR@:%sphinx_dir:g' < macro > %buildroot%_rpmmacrosdir/sphinx
sed -e 's:@SPHINX3_DIR@:%sphinx3_dir:g' < ../python3/macro3 > %buildroot%_rpmmacrosdir/sphinx3

#install -p -m644 %oname/directives/desc.py \
#	%buildroot%sphinx_dir/directives/

#if_with python3
#install -p -m644 %oname/directives/desc.py \
#	%buildroot%sphinx3_dir/directives/
#endif

# add pickle files

%make_build -C doc pickle

install -d %buildroot%sphinx_dir/doctrees
install -p -m644 doc/_build/doctrees/*.pickle \
	%buildroot%sphinx_dir/doctrees/
install -p -m644 %oname/pycode/*.pickle \
	%buildroot%sphinx_dir/pycode/
cp -R doc/_build/pickle %buildroot%sphinx_dir/
install -p -m644 conf.py.template \
	%buildroot%sphinx_dir/

#if_with python3
#pushd ../python3
#export PYTHONPATH=%buildroot%python3_sitelibdir
#export PATH=$PATH:%buildroot%_bindir
#sed -i 's|^SPHINXBUILD.*|SPHINXBUILD = py3_sphinx-build|' doc/Makefile
#make_build PYTHON=python3 -C doc pickle
#install -d %buildroot%sphinx3_dir/doctrees
#install -p -m644 doc/_build/doctrees/*.pickle \
#	%buildroot%sphinx3_dir/doctrees/
#cp -R doc/_build/pickle %buildroot%sphinx3_dir/
install -p -m644 conf.py.template \
	%buildroot%sphinx3_dir/
#popd
#endif

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/%name-files.req.list
# %name dirlist for %_rpmlibdir/files.req
%sphinx_dir	%name
EOF
%if_with python3
cat <<\EOF >%buildroot%_rpmlibdir/python3-module-%oname-files.req.list
# python3-module-%oname dirlist for %_rpmlibdir/files.req
%sphinx3_dir	python3-module-%oname
EOF
%endif

%check
%make_build test
%if_with python3
pushd ../python3
%make_build PYTHON=python3 test
popd
%endif

%files
%_bindir/*
%exclude %_bindir/py3_*
%sphinx_dir/
%exclude %sphinx_dir/tests
%exclude %sphinx_dir/pickle
%exclude %sphinx_dir/doctrees
%python_sitelibdir/*.egg-info
#_man1dir/*

%files devel

%files pickles
#dir %sphinx_dir/
%sphinx_dir/pickle
%sphinx_dir/doctrees

%files tests
#dir %sphinx_dir/
%sphinx_dir/tests
%sphinx_dir/tests

%files doc
%doc %_docdir/%name

%files -n rpm-macros-sphinx
%_rpmmacrosdir/sphinx
%_rpmlibdir/%name-files.req.list

%if_with python3
%files -n python3-module-%oname
%_bindir/py3_*
%sphinx3_dir/
%exclude %sphinx3_dir/tests
#exclude %sphinx3_dir/pickle
#exclude %sphinx3_dir/doctrees
%python3_sitelibdir/*.egg-info

%files -n python3-module-%oname-devel

#files -n python3-module-%oname-pickles
#dir %sphinx3_dir/
#%sphinx3_dir/pickle
#%sphinx3_dir/doctrees

%files -n python3-module-%oname-tests
#dir %sphinx3_dir/
%sphinx3_dir/tests

%files -n rpm-macros-sphinx3
%_rpmmacrosdir/sphinx3
%_rpmlibdir/python3-module-%oname-files.req.list
%endif

%changelog
