%define oname strippers.mixi

%def_with python3

Name: python-module-%oname
Version: 1.0
Release: alt1.1
Summary: Python library for mixi Graph API
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/strippers.mixi/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
BuildPreReq: python-tools-2to3
%endif

%py_requires strippers

%description
Python library for mixi Graph API.

%package -n python3-module-%oname
Summary: Python library for mixi Graph API
Group: Development/Python3
%py3_requires strippers

%description -n python3-module-%oname
Python library for mixi Graph API.

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
export LC_ALL=en_US.UTF-8

%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
export LC_ALL=en_US.UTF-8

%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%ifarch x86_64
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

%check
export LC_ALL=en_US.UTF-8
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%python_sitelibdir/*.egg-info
%python_sitelibdir/strippers/mixi

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/strippers/mixi
%endif

%changelog
