%define oname ua_parser
%def_disable check

%def_with python3

Name: python-module-%oname
Version: 0.4.1
Release: alt0.M80P.1
Summary: Python port of Browserscope's user agent parser
License: ASLv2.0
Group: Development/Python
Url: https://pypi.python.org/pypi/ua-parser/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/tobie/ua-parser.git
Source: %name-%version.tar
BuildArch: noarch
BuildRequires: python-module-pytest python-module-yaml python-modules-json

#BuildPreReq: python-module-setuptools-tests python-module-yaml
#BuildPreReq: python-modules-json

%py_provides %oname

%description
The crux of the original parser--the data collected by Steve Souders
over the years--has been extracted into a separate YAML file so as to be
reusable as is by implementations in other programming languages.

ua-parser is just a small wrapper around this data.

%if_with python3
%package -n python3-module-%oname
Summary:        %summary
Group:          Development/Python
BuildRequires: rpm-build-python3 python3-module-pytest python3-module-yaml

%description -n python3-module-%oname
The crux of the original parser--the data collected by Steve Souders
over the years--has been extracted into a separate YAML file so as to be
reusable as is by implementations in other programming languages.

ua-parser is just a small wrapper around this data.
%endif

%prep
%setup

cp -v regexes.* uap-core/
cp -v regexes.* py/ua_parser/

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug
#python setup.py sdist

%if_with python3
pushd ../python3
%python3_build_debug
#python3 setup.py sdist
popd
%endif

%install
%python_install

install -m644 py/%oname/regexes.* %buildroot%python_sitelibdir/%oname/

%if_with python3
pushd ../python3
%python3_install
install -m644 py/%oname/regexes.* %buildroot%python3_sitelibdir/%oname/
popd
%endif

%check
python setup.py test
rm -fR build
export PYTHONPATH=%buildroot%python_sitelibdir
py.test


%if_with python3
pushd ../python3
python3 setup.py test
rm -fR build
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test
popd
%endif

%files
%doc *.md *.txt *.markdown
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
