%define oname unittest2

%def_with python3
%def_disable check

Name: python-module-%oname
Version: 1.1.0
Release: alt2.hg20150630.1

Summary: Backport of Python 2.7 unittest module
License: Same as Python
Group: Development/Python

BuildArch: noarch

Url: http://pypi.python.org/pypi/unittest2

# hg clone https://hg.python.org/unittest2
Source: %name-%version.tar

%setup_python_module %oname
BuildRequires: python-module-pytest python-module-traceback2

#BuildPreReq: python-module-setuptools-tests
#BuildPreReq: python-module-traceback2 python-module-six
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildRequires: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-traceback2 python3-module-six
BuildRequires: python3-module-pytest python3-module-traceback2
BuildPreReq: python-tools-2to3
%endif

#%py_requires traceback2 six

%description
unittest2 is a backport of the new features added to the unittest
testing framework in Python 2.7. It is tested to run on Python 2.4 -
2.7.

%if_with python3
%package -n python3-module-%oname
Summary: Port of Python 2.7 unittest module
Group: Development/Python3
#%py3_requires traceback2 six

%description -n python3-module-%oname
unittest2 is a port of the features added to the unittest testing
framework in Python 2.7.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
for i in $(find ./ -name '*.py'); do
	2to3 -w -n $i
done
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
%endif
%python_install

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc README.txt
%_bindir/*
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc README.txt
#_bindir/*
%python3_sitelibdir/*
%endif

%changelog
