%define module_name validictory

%def_with python3

Name: python-module-%module_name
Version: 1.0.0
Release: alt1.a2.1
Summary: A general purpose Python data validator.
License: MIT
Group: Development/Python
Url: http://github.com/sunlightlabs/validictory

Source: %name-%version.tar

BuildArch: noarch
BuildRequires: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%setup_python_module %module_name

%description
A general purpose Python data validator.
Works with Python 2.6+ (Including Python 3)
Schema format based on JSON Schema Proposal (http://json-schema.org)
Contains code derived from jsonschema, by Ian Lewis and Yusuke Muraoka.

%package -n python3-module-%module_name
Summary: A general purpose Python data validator
Group: Development/Python3

%description -n python3-module-%module_name
A general purpose Python data validator.
Works with Python 2.6+ (Including Python 3)
Schema format based on JSON Schema Proposal (http://json-schema.org)
Contains code derived from jsonschema, by Ian Lewis and Yusuke Muraoka.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc AUTHORS.txt LICENSE.txt README.rst
%python_sitelibdir/%module_name
%python_sitelibdir/%module_name-*.egg-info
%exclude %python_sitelibdir/%module_name/tests

%if_with python3
%files -n python3-module-%module_name
%doc AUTHORS.txt LICENSE.txt README.rst
%python3_sitelibdir/%module_name
%python3_sitelibdir/%module_name-*.egg-info
%exclude %python3_sitelibdir/%module_name/tests
%endif

%changelog
