%define oname vcversioner

%def_with python3

Name: python-module-%oname
Version: 2.14.0.0
Release: alt2.git20140715.1
Summary: Use version control tags to discover version numbers
License: ISCL
Group: Development/Python
Url: https://pypi.python.org/pypi/vcversioner/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/habnabit/vcversioner.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires: git-core python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools-tests
%endif

%py_provides %oname

%description
Elevator pitch: you can write a setup.py with no version information
specified, and vcversioner will find a recent, properly-formatted VCS
tag and extract a version from it.

It's much more convenient to be able to use your version control
system's tagging mechanism to derive a version number than to have to
duplicate that information all over the place. I eventually ended up
copy-pasting the same code into a couple different setup.py files just
to avoid duplicating version information. But, copy-pasting is dumb and
unit testing setup.py files is hard. This code got factored out into
vcversioner.

%package -n python3-module-%oname
Summary: Use version control tags to discover version numbers
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
Elevator pitch: you can write a setup.py with no version information
specified, and vcversioner will find a recent, properly-formatted VCS
tag and extract a version from it.

It's much more convenient to be able to use your version control
system's tagging mechanism to derive a version number than to have to
duplicate that information all over the place. I eventually ended up
copy-pasting the same code into a couple different setup.py files just
to avoid duplicating version information. But, copy-pasting is dumb and
unit testing setup.py files is hard. This code got factored out into
vcversioner.

%prep
%setup

git config --global user.email "real at altlinux.org"
git config --global user.name "REAl"
git init-db
git add . -A
git commit -a -m "%version"
git tag %version -m "%version"

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
py.test -vv
%if_with python3
pushd ../python3
python3 setup.py test
py.test-%_python3_version -vv
popd
%endif

%files
%doc COPYING *.rst docs/*.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc COPYING *.rst docs/*.rst
%python3_sitelibdir/*
%endif

%changelog
