%define _unpackaged_files_terminate_build 1
%define modulename virtualenv

%def_with check

Name: python-module-%modulename
Version: 15.1.0
Release: alt3%ubt

Summary: Virtual Python Environment builder
License: MIT
Group: Development/Python
# git://github.com/pypa/virtualenv.git
Url: http://pypi.python.org/pypi/virtualenv

Source: %name-%version.tar.gz
Patch1: python3-system-sys.path.patch
Patch2: allow_internal_symlinks.patch
Patch3: python3-installation-within-the-bare-virtualenv.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3
BuildRequires: python-module-setuptools
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: python-module-mock
BuildRequires: python-module-nose
BuildRequires: python-module-pytest
BuildRequires: python3-module-mock
BuildRequires: python3-module-nose
BuildRequires: python3-module-pytest
%endif

BuildArch: noarch

%description
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python

%description -l ru_RU.UTF-8
Утилита для создания изолированных окружений для Python.

С Virtualenv вы можете создать независимые наборы библиотек для каждого
вашего проекта. Опционально вы можете запретить использование системных
библиотек.

Просто выполните "virtualenv /your/dir" и полное виртуальное окружение Python
будет создано в каталоге, который вы указали (setuptools  и easy_install будут
также установлены и при вызове будут устанавливать новые библиотеки в ваше
виртуальное окружение). Чтобы выполнить ваши скрипты в вновь созданном окружение
запускайте их при помощи /your/dir/bin/python

%package -n python3-module-%modulename
Summary: Virtual Python 3 Environment builder
Group: Development/Python3

%description -n python3-module-%modulename
Tool to create isolated Python environments.

With virtualenv it is became possible to keep separate set of python libraries
for each of your project.

Just exec "virtualenv /your/dir" and whole python enviroment (including
setuptools and easy_install) will be installed there. You could exec scripts
in newly created environment by invoking /your/dir/bin/python

%prep
%setup
%patch1 -p2
%patch2 -p1
%patch3 -p2
# to reflect virtualenv_embedded/ updates on virtualenv.py
python bin/rebuild-script.py

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
pushd ../python3
%python3_install
mv %buildroot%_bindir/virtualenv %buildroot%_bindir/virtualenv3
popd

%python_install

%check
py.test -v

pushd ../python3
py.test3 -v
popd

%files
%doc docs/* *.txt *.rst
%_bindir/virtualenv
%exclude %_bindir/virtualenv3
%python_sitelibdir/*

%files -n python3-module-%modulename
%doc docs/* *.txt *.rst
%_bindir/virtualenv3
%python3_sitelibdir/*

%changelog
