%define oname webtest

%def_with python3

Name: python-module-%oname
Version: 2.0.19
Release: alt1.dev0.git20150724.1.1
Summary: Helper to test WSGI applications
License: MIT
Group: Development/Python
Url: http://webtest.pythonpaste.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://github.com/Pylons/webtest.git
Source: WebTest-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-build-python
#BuildPreReq: python-devel python-module-setuptools
#BuildPreReq: python-module-sphinx-devel python-module-Pygments
#BuildPreReq: python-module-BeautifulSoup4 python-module-webob
#BuildPreReq: python-module-waitress
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: libgpg-error python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-html5lib python-module-jinja2 python-module-jinja2-tests python-module-lxml python-module-markupsafe python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python-modules-wsgiref python-modules-xml python3 python3-base python3-module-Pygments python3-module-babel python3-module-cssselect python3-module-docutils python3-module-genshi python3-module-jinja2 python3-module-pytz python3-module-setuptools python3-module-snowballstemmer
BuildRequires: python-module-BeautifulSoup4 python-module-alabaster python-module-docutils python-module-objects.inv python-module-waitress python-module-webob python3-module-html5lib python3-module-sphinx rpm-build-python3 time

#BuildRequires: python3-devel python3-module-distribute
#BuildPreReq: python3-module-sphinx python3-module-Pygments
%endif

%description
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.

%package pickles
Summary: Pickles for WebTest
Group: Development/Python

%description pickles
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.

This package contains pickles for WebTest.

%if_with python3
%package -n python3-module-%oname
Summary: Helper to test WSGI applications (Python 3)
Group: Development/Python3

%description -n python3-module-%oname
This wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

This is based on ``paste.fixture.TestApp``.
%endif

%prep
%setup

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

# for docs
export PYTHONPATH=%buildroot%python_sitelibdir
make -C docs pickle SPHINXBUILD=sphinx-build
make -C docs html SPHINXBUILD=sphinx-build

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%files
%doc docs/_build/html/*
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
