%define oname xstatic

%def_with python3

Name: python-module-%oname
Version: 1.0.1
Release: alt1.1
Summary: XStatic base package with minimal support code
License: MIT
Group: Development/Python
Url: https://pypi.python.org/pypi/XStatic/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools-tests
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools-tests
%endif

%py_provides %oname

%description
The goal of XStatic family of packages is to provide static file
packages with minimal overhead - without selling you some dependencies
you don't want.

XStatic has some minimal support code for working with the XStatic-*
packages.

%package -n python3-module-%oname
Summary: XStatic base package with minimal support code
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
The goal of XStatic family of packages is to provide static file
packages with minimal overhead - without selling you some dependencies
you don't want.

XStatic has some minimal support code for working with the XStatic-*
packages.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%ifarch x86_64
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

install -p -m644 %oname/__init__.py %buildroot%python_sitelibdir/%oname/
cp -fR %oname/pkg %buildroot%python_sitelibdir/%oname/
%if_with python3
pushd ../python3
install -p -m644 %oname/__init__.py %buildroot%python3_sitelibdir/%oname/
cp -fR %oname/pkg %buildroot%python3_sitelibdir/%oname/
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%endif

%changelog
