%define oname z3c.resource

%def_with python3

Name: python-module-%oname
Version: 0.5.0
Release: alt3.1
Summary: Local resource container implementation for Zope3
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/z3c.resource/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%py_requires z3c.proxy zope.annotation zope.app.component
%py_requires zope.app.container zope.app.generations zope.component
%py_requires zope.event zope.interface zope.lifecycleevent zope.location
%py_requires zope.publisher zope.traversing

%description
This package provides a local resource container implementation for
Zope3.

%package -n python3-module-%oname
Summary: Local resource container implementation for Zope3
Group: Development/Python3
%py3_requires z3c.proxy zope.annotation zope.app.component
%py3_requires zope.app.container zope.app.generations zope.component
%py3_requires zope.event zope.interface zope.lifecycleevent zope.location
%py3_requires zope.publisher zope.traversing

%description -n python3-module-%oname
This package provides a local resource container implementation for
Zope3.

%package -n python3-module-%oname-tests
Summary: Tests for z3c.resource
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires z3c.coverage zope.annotation z3c.testing zope.app.testing
%py3_requires zope.publisher zope.testing

%description -n python3-module-%oname-tests
This package provides a local resource container implementation for
Zope3.

This package contains tests for z3c.resource.

%package tests
Summary: Tests for z3c.resource
Group: Development/Python
Requires: %name = %version-%release
%py_requires z3c.coverage zope.annotation z3c.testing zope.app.testing
%py_requires zope.publisher zope.testing

%description tests
This package provides a local resource container implementation for
Zope3.

This package contains tests for z3c.resource.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
find -type f -name '*.py' -exec 2to3 -w -n '{}' +
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/test*

%files tests
%python_sitelibdir/*/*/test*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*
%endif

%changelog
