%define oname zc.recipe.egg

%def_with python3

Name: python-module-%oname
Version: 2.0.1
Release: alt2.1
Summary: Recipe for installing Python package distributions as eggs
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zc.recipe.egg/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%py_requires zc.recipe zc.buildout

%description
The egg-installation recipe installs eggs into a buildout eggs
directory. It also generates scripts in a buildout bin directory with
egg paths baked into them.

%package -n python3-module-%oname
Summary: Recipe for installing Python package distributions as eggs
Group: Development/Python3
%py3_requires zc.recipe zc.buildout

%description -n python3-module-%oname
The egg-installation recipe installs eggs into a buildout eggs
directory. It also generates scripts in a buildout bin directory with
egg paths baked into them.

%package -n python3-module-%oname-tests
Summary: Tests for zc.recipe.egg
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.testing

%description -n python3-module-%oname-tests
The egg-installation recipe installs eggs into a buildout eggs
directory. It also generates scripts in a buildout bin directory with
egg paths baked into them.

This package contains tests for zc.recipe.egg.

%package tests
Summary: Tests for zc.recipe.egg
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing

%description tests
The egg-installation recipe installs eggs into a buildout eggs
directory. It also generates scripts in a buildout bin directory with
egg paths baked into them.

This package contains tests for zc.recipe.egg.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/*/tests.*

%files tests
%python_sitelibdir/*/*/*/tests.*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/*/tests.*
%python3_sitelibdir/*/*/*/*/tests.*
%endif

%changelog
