%define oname zc.shortcut

%def_with python3

Name: python-module-%oname
Version: 1.0
Release: alt3.1
Summary: Symlinks for Zope 3
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zc.shortcut/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%py_requires zc zc.displayname

%description
Shortcuts are objects that allow other objects (their target) to appear
to be located in places other than the target's actual location. They
are somewhat like a symbolic link in Unix-like operating systems.

%package -n python3-module-%oname
Summary: Symlinks for Zope 3
Group: Development/Python3
%py3_requires zc zc.displayname

%description -n python3-module-%oname
Shortcuts are objects that allow other objects (their target) to appear
to be located in places other than the target's actual location. They
are somewhat like a symbolic link in Unix-like operating systems.

%package -n python3-module-%oname-tests
Summary: Tests for Symlinks for Zope 3
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
Shortcuts are objects that allow other objects (their target) to appear
to be located in places other than the target's actual location. They
are somewhat like a symbolic link in Unix-like operating systems.

This package contains tests for Symlinks for Zope 3.

%package tests
Summary: Tests for Symlinks for Zope 3
Group: Development/Python
Requires: %name = %version-%release

%description tests
Shortcuts are objects that allow other objects (their target) to appear
to be located in places other than the target's actual location. They
are somewhat like a symbolic link in Unix-like operating systems.

This package contains tests for Symlinks for Zope 3.

%prep
%setup

rm -f $(find ./ -name '._*')

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests.*

%files tests
%python_sitelibdir/*/*/tests.*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests.*
%python3_sitelibdir/*/*/*/tests.*
%endif

%changelog
