%define oname zope.app.sqlexpr

%def_with python3

Name: python-module-%oname
Version: 0.1
Release: alt3.1
Summary: allow quick SQL queries in TALES expressions and Zope Page Templates
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.app.sqlexpr/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%py_requires zope.app zope.component zope.interface zope.tales
%py_requires zope.exceptions zope.rdb

%description
The goal of the SQL TALES expression is to allow quick SQL queries right
out of TALES expressions and Zope Page Templates. While this is
certainly not the Zopeish way of doing things, it allows the newbie Web
scripter an easier entrance to the world of Zope 3.

%package -n python3-module-%oname
Summary: allow quick SQL queries in TALES expressions and Zope Page Templates
Group: Development/Python3
%py3_requires zope.app zope.component zope.interface zope.tales
%py3_requires zope.exceptions zope.rdb

%description -n python3-module-%oname
The goal of the SQL TALES expression is to allow quick SQL queries right
out of TALES expressions and Zope Page Templates. While this is
certainly not the Zopeish way of doing things, it allows the newbie Web
scripter an easier entrance to the world of Zope 3.

%package -n python3-module-%oname-tests
Summary: Tests for zope.app.sqlexpr
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.app.sqlexpr

%description -n python3-module-%oname-tests
The goal of the SQL TALES expression is to allow quick SQL queries right
out of TALES expressions and Zope Page Templates. While this is
certainly not the Zopeish way of doing things, it allows the newbie Web
scripter an easier entrance to the world of Zope 3.

This package contains tests for zope.app.sqlexpr.

%package tests
Summary: Tests for zope.app.sqlexpr
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.app.sqlexpr

%description tests
The goal of the SQL TALES expression is to allow quick SQL queries right
out of TALES expressions and Zope Page Templates. While this is
certainly not the Zopeish way of doing things, it allows the newbie Web
scripter an easier entrance to the world of Zope 3.

This package contains tests for zope.app.sqlexpr.

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/*/tests.*

%files tests
%python_sitelibdir/*/*/*/tests.*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/*/tests.*
%python3_sitelibdir/*/*/*/*/tests.*
%endif

%changelog
