%define oname zope.app.wfmc

%def_with python3

Name: python-module-%oname
Version: 0.1.2
Release: alt3.1
Summary: Zope Application integration for ``zope.wfmc``
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.app.wfmc/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python-tools-2to3
%endif

%py_requires zope.app zope.interface zope.schema zope.configuration
%py_requires zope.wfmc zope.component

%description
This package provides Zope application level integration of the
zope.wfmc package including ZCML directives.

%package -n python3-module-%oname
Summary: Zope Application integration for ``zope.wfmc``
Group: Development/Python3
%py3_requires zope.app zope.interface zope.schema zope.configuration
%py3_requires zope.wfmc zope.component

%description -n python3-module-%oname
This package provides Zope application level integration of the
zope.wfmc package including ZCML directives.

%package -n python3-module-%oname-tests
Summary: Tests for zope.app.wfmc
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.app.testing

%description -n python3-module-%oname-tests
This package provides Zope application level integration of the
zope.wfmc package including ZCML directives.

This package contains tests for zope.app.wfmc.

%package tests
Summary: Tests for zope.app.wfmc
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.app.testing

%description tests
This package provides Zope application level integration of the
zope.wfmc package including ZCML directives.

This package contains tests for zope.app.wfmc.

%prep
%setup

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/*/tests.*

%files tests
%python_sitelibdir/*/*/*/tests.*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/*/tests.*
%python3_sitelibdir/*/*/*/*/tests.*
%endif

%changelog
