%define oname zope.catalog

%def_with python3

Name: python-module-%oname
Version: 4.0.0
Release: alt3.1
Summary: Cataloging and Indexing Framework for the Zope Toolkit
License: ZPLv2.1
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.catalog/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%py_requires zope ZODB3 zope.annotation zope.intid zope.component
%py_requires zope.container zope.index zope.interface persistent
%py_requires zope.lifecycleevent zope.location zope.schema

%description
Catalogs provide management of collections of related indexes with a
basic search algorithm.

%package -n python3-module-%oname
Summary: Cataloging and Indexing Framework for the Zope Toolkit
Group: Development/Python3
%py3_requires zope ZODB3 zope.annotation zope.intid zope.component
%py3_requires zope.container zope.index zope.interface persistent
%py3_requires zope.lifecycleevent zope.location zope.schema

%description -n python3-module-%oname
Catalogs provide management of collections of related indexes with a
basic search algorithm.

%package -n python3-module-%oname-tests
Summary: Tests for zope.catalog
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.testing zope.site

%description -n python3-module-%oname-tests
Catalogs provide management of collections of related indexes with a
basic search algorithm.

This package contains tests for zope.catalog.

%package tests
Summary: Tests for zope.catalog
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing zope.site

%description tests
Catalogs provide management of collections of related indexes with a
basic search algorithm.

This package contains tests for zope.catalog.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/tests.*

%files tests
%python_sitelibdir/*/*/tests.*

%if_with python3
%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests.*
%exclude %python3_sitelibdir/*/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/tests.*
%python3_sitelibdir/*/*/*/tests.*
%endif

%changelog
