%define oname zope.globalrequest

%def_with python3

Name: python-module-%oname
Version: 1.0
Release: alt3.1
Summary: Global way of retrieving the currently active request
License: ZPL
Group: Development/Python
Url: http://pypi.python.org/pypi/zope.globalrequest/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%py_requires zope zope.interface

%description
This package provides a global way to retrieve the currently active
request object in a zope-based web framework.

%package -n python3-module-%oname
Summary: Global way of retrieving the currently active request
Group: Development/Python3
%py3_requires zope zope.interface

%description -n python3-module-%oname
This package provides a global way to retrieve the currently active
request object in a zope-based web framework.

%package -n python3-module-%oname-tests
Summary: Tests for zope.globalrequest
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
%py3_requires zope.testing zope.configuration zope.app.publisher
%py3_requires zope.app.securitypolicy zope.app.testing
%py3_requires zope.app.zcmlfiles zope.testbrowser

%description -n python3-module-%oname-tests
This package provides a global way to retrieve the currently active
request object in a zope-based web framework.

This package contains tests for zope.globalrequest.

%package tests
Summary: Tests for zope.globalrequest
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing zope.configuration zope.app.publisher
%py_requires zope.app.securitypolicy zope.app.testing
%py_requires zope.app.zcmlfiles zope.testbrowser

%description tests
This package provides a global way to retrieve the currently active
request object in a zope-based web framework.

This package contains tests for zope.globalrequest.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install
%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* \
	%buildroot%python_sitelibdir/
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%ifarch x86_64
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif
%endif

%files
%doc *.txt
%python_sitelibdir/*
%exclude %python_sitelibdir/*.pth
%exclude %python_sitelibdir/*/*/*test*

%files tests
%python_sitelibdir/*/*/*test*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/*test*
%exclude %python3_sitelibdir/*/*/*/*test*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/*/*test*
%python3_sitelibdir/*/*/*/*test*
%endif

%changelog
