%define oname zope.hookable
%define fname python-module-%oname
%define descr \
Support the efficient creation of hookable objects, which are callable \
objects that are meant to be replaced by other callables, at least \
optionally. \
\
The idea is you create a function that does some default thing and make \
it hookable. Later, someone can modify what it does by calling its \
sethook method and changing its implementation.  All users of the \
function, including those that imported it, will see the change.

Name: %fname
Version: 4.2.0
Release: alt1

%if ""==""
Summary: Hookable object support
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: ZPLv2.1
Url: http://pypi.python.org/pypi/zope.hookable/
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python rpm-macros-sphinx

%py_requires zope

# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: elfutils python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python3 python3-base
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv python3-devel python3-module-setuptools rpm-build-python3 time

%if ""!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
BuildArch: noarch
%endif

%description
%descr

%if ""!=""
This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for zope.hookable
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for zope.hookable.
%else
%package -n %fname-tests
Summary: Tests for zope.hookable
Group: Development/Python
Requires: %name = %version-%release
%py_requires zope.testing

%description -n %fname-tests
%descr

This package contains tests for zope.hookable.
%endif

%prep
%setup
%if ""!=""
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
%if ""==""
%python_build
%else
export PYTHONPATH=$PWD/src
%make -C docs pickle
%make -C docs html
%endif

%install
%if ""==""
%python_install
%else
install -d %buildroot%python_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if ""==""
%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/*/tests

%files -n %fname-tests
%python_sitelibdir/*/*/tests

%else

%files
%doc docs/_build/html/*

%files -n %fname-pickles
%python_sitelibdir/*/pickle

%endif

%changelog
