%define oname dateutil

%def_disable check

Name: python3-module-%oname
Version: 2.4.2
Release: alt1.git20150728.1.1

Summary: Extensions to the standard datetime module (Python 3)

License: PSF
Group: Development/Python3
Url: http://labix.org/python-dateutil

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

%add_python3_req_skip _winreg winreg

# https://github.com/dateutil/dateutil.git
Source: python-dateutil-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python3 python3-base python3-module-setuptools
BuildRequires: python3-module-pytest rpm-build-python3

#BuildRequires: python3-devel python3-module-setuptools-tests
#BuildPreReq: pytz-zoneinfo python3-module-six
# texlive-base-bin

%description
The dateutil module provides powerful extensions to the standard
datetime module, available in Python 2.3+. Allows:
- computing of relative deltas (next month, next year, next monday,
  last week of month, etc),
- computing of dates based on very flexible recurrence rules, using a
  superset of the [WWW] iCalendar specification,
- parsing of RFC strings,
- peneric parsing of dates in almost any string format.

%prep
%setup -n python-%oname-%version

%build
%python3_build

%install
%python3_install

%check
python3 setup.py test
python3 dateutil/test/test.py

%files
%doc LICENSE NEWS README*
%python3_sitelibdir/*egg-info
%python3_sitelibdir/%oname


%changelog
