%define oname fs

Name: python3-module-%oname
Version: 0.5.5a1
Release: alt1
Summary: Filesystem abstraction layer
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/fs/

# https://github.com/PyFilesystem/pyfilesystem
Source: %name-%version.tar
Patch: %name-%version-%release.patch
BuildArch: noarch

%py3_provides %oname
%add_python3_req_skip wx libarchive

BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools-tests
#BuildPreReq: python3-module-dexml
#BuildPreReq: python3-module-django
# for test_expose in %%check:
BuildPreReq: python3-module-paramiko
# for test_ftpfs in %%check:
BuildPreReq: python-module-pyftpdlib
# for FUSE tests (which are not run in hasher anyway, but some setup is done)
BuildPreReq: libfuse
# for archivefs tests in %%check -- not available for Python3 yet:
#BuildPreReq: python3-module-libarchive

# upstream commentary:
#
#  fs/tests/test_s3fs:  testcases for the S3FS module
#
# These tests are set up to be skipped by default, since they're very slow,
# require a valid AWS account, and cost money.
#
# ALT: the availability of boto module determines whether they are run.
# (Thanks to the annotations from https://github.com/smartfile/pyfilesystem .)
BuildConflicts: python3-module-boto


BuildRequires: python3-module-django python3-module-ecdsa python3-module-pycrypto python3-module-setuptools-tests python3-module-requests

%description
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

This package contains tests for %oname.

%prep
%setup
%patch -p1

%python3_build_debug

%install
%python3_install
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd

%check
# for filenames:
export LC_ALL=en_US.utf8
# for print statements:
export PYTHONIOENCODING=UTF-8
python3 setup.py test

%files
%doc AUTHORS *.txt
%python3_sitelibdir/*
%_bindir/*.py3
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/*/test*
%exclude %python3_sitelibdir/*/*/*/*/test*

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/*/test*
%python3_sitelibdir/*/*/*/*/test*

%changelog
