%def_with debug

Name: 	 qcad
Version: 3.20.1.3
Release: alt1.M80P.1
Summary: A professional CAD system
Summary(ru_RU.UTF-8): Профессиональная система CAD

Url: 	 http://www.ribbonsoft.com/qcad.html
# VCS:   https://github.com/qcad/qcad.git
License: GPLv3 with exceptions
Group:   Graphics

Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: qcad-%version.tar
Source1: qcad.desktop
Source2: qcad
Patch:   %name-%version-%release.patch

BuildRequires: gcc-c++ qt5-base-devel python
BuildRequires: desktop-file-utils
BuildRequires: libdbus-devel
BuildRequires: libGL-devel
BuildRequires: libGLU-devel
BuildRequires: libssl-devel
BuildRequires: qt5-designer
BuildRequires: qt5-imageformats
BuildRequires: qt5-script-devel
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-tools-devel-static
BuildRequires: qt5-webengine-devel
BuildRequires: qt5-webkit-devel
BuildRequires: qt5-xmlpatterns-devel
BuildRequires: zlib-devel

Requires: qt5-translations qt5-imageformats

%description
QCad is a professional CAD System. With QCad you can easily construct
and change drawings with ISO-text and many other features and save them
as DXF-files. These DXF-files are the interface to many CAD-systems such
as AutoCAD(TM) and many others.

%description -l ru_RU.UTF-8
QCad это профессиональная CAD система. С QCad вы можете легко создавать
и изменять рисунки с вставленным текстом и сохранять это в DXF файлы.
Через DXF файлы есть возможность обмениваться данными с другими CAD
системами (например, AutoCAD).

%prep
%setup -q
%patch -p1
%if_with debug
echo 'DEFINES -= QT_NO_DEBUG_OUTPUT' >> shared.pri
%endif
%qmake_qt5
#lupdate-qt5 %name.pro

if [ ! -e src/3rdparty/qt-labs-qtscriptgenerator-%_qt5_version ] ; then
    pushd src/3rdparty
    cp -ar qt-labs-qtscriptgenerator-5.7.0 qt-labs-qtscriptgenerator-%_qt5_version
    mv qt-labs-qtscriptgenerator-%_qt5_version/qt-labs-qtscriptgenerator-5.7.0.pro qt-labs-qtscriptgenerator-%_qt5_version/qt-labs-qtscriptgenerator-%_qt5_version.pro
    popd
fi

%build
#export NPROCS=1
%make_build

%install
%installqt5
# Main executable
install -Dm755 release/qcad-bin %buildroot%_libdir/%name/qcad-bin

# Make executable wrapper
install -Dm0755 %SOURCE2 %buildroot%_bindir/qcad

# Libraries
install -d %buildroot%_libdir
cp release/lib*.so %buildroot%_libdir

# Translations
install -d %buildroot%_libdir/%name/ts
cp ts/*.qm %buildroot%_libdir/%name/ts

# Documentation
install -Dm644 readme.txt %buildroot%_libdir/%name/readme.txt

echo other stuff
# Other stuff
cp -a   examples \
	fonts \
	libraries \
	linetypes \
	patterns \
	plugins \
	scripts \
	"%buildroot%_libdir/%name/"

# Desktop file
install -Dm644 %SOURCE1 %buildroot%_desktopdir/%name.desktop

# Icon
install -Dm644 ./support/doc/api/qcad_icon.png %buildroot%_iconsdir/hicolor/64x64/apps/%name.png

# Add localization fo qcad.lang
for l in $(find %buildroot%_libdir/%name/qm -name \*.qm); do
	echo -n $l | sed 's,.*_\(.*\)\.qm,%%lang\(\1\) ,' >> %name.lang
	echo $l | sed "s,%buildroot,," >> %name.lang
done

%files
%doc gpl-3.0-exceptions.txt gpl-3.0.txt README.md LICENSE.txt
%_bindir/%name
%dir %_libdir/%name
%_libdir/lib*.so*
%_libdir/%name/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/%name.png

%changelog
