
%global qt_module qtserialbus

Name: qt5-serialbus
Version: 5.9.6
Release: alt2%ubt

Group: System/Libraries
Summary: Qt5 - SerialBus component
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-opensource-src-%version.tar
Patch1: alt-segfault.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: qt5-base-devel qt5-serialport-devel qt5-tools

%description
Support for CAN and potentially other serial buses.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: qt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
BuildArch: noarch
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libqt5-serialbus
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
%description -n libqt5-serialbus
%summary

%prep
%setup -n %qt_module-opensource-src-%version
%patch1 -p1
syncqt.pl-qt5 -version %version -private

%build
%qmake_qt5
%make_build
export QT_HASH_SEED=0
%make docs

%install
%install_qt5
%make INSTALL_ROOT=%buildroot install_docs ||:

%files common

%files
%_bindir/canbusutil-qt5
%_qt5_bindir/canbusutil

%files -n libqt5-serialbus
%_qt5_libdir/libQt?SerialBus.so.*
%_qt5_plugindir/canbus/

%files devel
%_qt5_headerdir/Qt*/
%_qt5_libdatadir/libQt*.so
%_qt5_libdatadir/libQt*.prl
%_qt5_libdir/libQt*.so
%_qt5_libdir/libQt*.prl
%_qt5_libdir/cmake/Qt*/
%_qt5_libdir/pkgconfig/Qt*.pc
%_qt5_archdatadir/mkspecs/modules/qt_lib_*.pri

%files doc
%_qt5_docdir/*

%changelog
