%define IF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define IF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define IF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define IF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"
%define IF_ver_eq() %if "%(rpmvercmp '%1' '%2')" == "0"
%define IF_ver_not_gt() %if "%(rpmvercmp '%1' '%2')" <= "0"
%define IF_ver_not_gteq() %if "%(rpmvercmp '%1' '%2')" < "0"
%define IF_ver_not_lt() %if "%(rpmvercmp '%2' '%1')" <= "0"
%define IF_ver_not_lteq() %if "%(rpmvercmp '%2' '%1')" < "0"
%define IF_ver_not_eq() %if "%(rpmvercmp '%1' '%2')" != "0"

%global qt_module qtwebengine
%ifarch %ix86
%set_verify_elf_method relaxed
%endif
%def_enable always_reducing_debuginfo

%define is_ffmpeg %([ -n "`rpmquery --qf '%%{SOURCERPM}' libavformat-devel 2>/dev/null | grep -e '^libav'`" ] && echo 0 || echo 1)
%if %is_ffmpeg
%define qt_ffmpeg_type system-ffmpeg
%else
%define qt_ffmpeg_type %nil
%endif

Name: qt5-webengine
Version: 5.10.1
Release: alt3%ubt

Group: System/Libraries
Summary: Qt5 - QtWebEngine components
Url: http://qt.io/
License: GPLv2 / GPLv3 / LGPLv3

Source: %qt_module-opensource-src-%version.tar
# FC
Patch1:  qtwebengine-everywhere-src-5.10.0-linux-pri.patch
Patch2:  qtwebengine-opensource-src-5.6.0-no-icudtl-dat.patch
Patch3:  qtwebengine-opensource-src-5.9.0-fix-extractcflag.patch
Patch4:  qtwebengine-everywhere-src-5.10.0-system-nspr-prtime.patch
Patch5:  qtwebengine-everywhere-src-5.10.0-system-icu-utf.patch
Patch6:  qtwebengine-everywhere-src-5.10.1-no-sse2.patch
Patch7:  qtwebengine-opensource-src-5.9.2-arm-fpu-fix.patch
Patch8: qtwebengine-opensource-src-5.9.0-openmax-dl-neon.patch
Patch9: qtwebengine-opensource-src-5.9.0-webrtc-neon-detect.patch
Patch10: qtwebengine-everywhere-src-5.10.0-gn-bootstrap-verbose.patch
Patch11: qtwebengine-everywhere-src-5.10.0-icu59.patch
Patch12: qtwebengine-everywhere-src-5.10.0-no-aspirational-scripts.patch
Patch13: qtwebengine-everywhere-src-5.10.1-security-5.9.5.patch
Patch14: qtwebengine-everywhere-src-5.10.1-CVE-2018-6033.patch
# ALT
Patch100: alt-pepflashplayer.patch
Patch101: alt-codecs.patch
Patch102: alt-find-vpx.patch

# Automatically added by buildreq on Sun Apr 03 2016
# optimized out: fontconfig fontconfig-devel gcc-c++ glib2-devel kf5-attica-devel kf5-kjs-devel libEGL-devel libGL-devel libX11-devel libXScrnSaver-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXext-devel libXfixes-devel libXi-devel libXrandr-devel libXrender-devel libXtst-devel libfreetype-devel libgpg-error libharfbuzz-devel libharfbuzz-icu libicu-devel libnspr-devel libqt5-clucene libqt5-core libqt5-gui libqt5-help libqt5-network libqt5-positioning libqt5-qml libqt5-quick libqt5-sql libqt5-webchannel libqt5-widgets libstdc++-devel libxml2-devel pkg-config python-base python-modules python-modules-compiler python-modules-email python-modules-encodings python-modules-multiprocessing python-modules-xml python3 python3-base qt5-base-devel qt5-declarative-devel qt5-location-devel qt5-phonon-devel qt5-tools qt5-webchannel-devel qt5-webkit-devel xorg-compositeproto-devel xorg-damageproto-devel xorg-fixesproto-devel xorg-inputproto-devel xorg-kbproto-devel xorg-randrproto-devel xorg-recordproto-devel xorg-renderproto-devel xorg-scrnsaverproto-devel xorg-xextproto-devel xorg-xproto-devel zlib-devel
#BuildRequires: git-core gperf kde5-akonadi-calendar-devel kde5-gpgmepp-devel kde5-kalarmcal-devel kde5-kblog-devel kde5-kcalcore-devel kde5-kcalutils-devel kde5-kcontacts-devel kde5-kholidays-devel kde5-kidentitymanagement-devel kde5-kimap-devel kde5-kldap-devel kde5-kmailtransport-devel kde5-kmbox-devel kde5-kmime-devel kde5-kontactinterface-devel kde5-kpimtextedit-devel kde5-ktnef-devel kde5-pimlibs-devel kde5-syndication-devel kf5-bluez-qt-devel kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdesu-devel kf5-kdewebkit-devel kf5-kdnssd-devel kf5-kemoticons-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-khtml-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kidletime-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-kjsembed-devel kf5-knewstuff-devel kf5-knotifications-devel kf5-knotifyconfig-devel kf5-kparts-devel kf5-kpeople-devel kf5-kplotting-devel kf5-kpty-devel kf5-kross-devel kf5-krunner-devel kf5-kservice-devel kf5-ktexteditor-devel kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwayland-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-kxmlrpcclient-devel kf5-libkscreen-devel kf5-modemmanager-qt-devel kf5-networkmanager-qt-devel kf5-solid-devel kf5-sonnet-devel kf5-threadweaver-devel libalsa-devel libcap-devel libdbus-devel libevent-devel libexpat-devel libjpeg-devel libminizip-devel libnss-devel libopus-devel libpci-devel libpng-devel libprotobuf-devel libpulseaudio-devel libre2-devel libsnappy-devel libsrtp-devel libvpx-devel libwebp-devel libxslt-devel ninja-build protobuf-compiler python-module-google python-module-simplejson python-modules-json python3-dev qt5-connectivity-devel qt5-multimedia-devel qt5-script-devel qt5-sensors-devel qt5-serialport-devel qt5-svg-devel qt5-tools-devel qt5-webengine-devel qt5-websockets-devel qt5-x11extras-devel qt5-xmlpatterns-devel ruby ruby-stdlibs yasm
BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): libavformat-devel
%if %is_ffmpeg
BuildRequires: libavcodec-devel libavutil-devel libavformat-devel libopus-devel libvpx-devel
%endif
BuildRequires: /proc
BuildRequires: flex libicu-devel libEGL-devel
BuildRequires: git-core gperf libalsa-devel libcap-devel libdbus-devel libevent-devel libexpat-devel libjpeg-devel libminizip-devel libnss-devel
BuildRequires: fontconfig-devel libdrm-devel yasm gyp libudev-devel libxml2-devel libXNVCtrl-devel jsoncpp-devel liblcms2-devel
BuildRequires: libopus-devel libpci-devel libpng-devel libprotobuf-devel libpulseaudio-devel libre2-devel libsnappy-devel libsrtp2-devel
BuildRequires: libvpx-devel libwebp-devel libxslt-devel ninja-build protobuf-compiler libva-devel libvdpau-devel
BuildRequires: python-devel python-module-simplejson python-modules-json
BuildRequires: qt5-connectivity-devel qt5-multimedia-devel qt5-script-devel qt5-sensors-devel qt5-serialport-devel qt5-svg-devel qt5-tools-devel
BuildRequires: qt5-websockets-devel qt5-x11extras-devel qt5-xmlpatterns-devel qt5-declarative-devel qt5-location-devel qt5-webchannel-devel
BuildRequires: qt5-phonon-devel

%description
%summary.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: qt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
BuildArch: noarch
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libqt5-webengine
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: qt5-quickcontrols2
%description -n libqt5-webengine
%summary

%package -n libqt5-webenginecore
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: qt5-quickcontrols2
%description -n libqt5-webenginecore
%summary

%package -n libqt5-webenginewidgets
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: qt5-quickcontrols2
%description -n libqt5-webenginewidgets
%summary

%prep
%define icu_ver %{get_version libicu-devel}
%IF_ver_gteq %icu_ver 5.9
%def_enable system_icu
%else
%def_disable system_icu
%endif
%setup -n %qt_module-opensource-src-%version
mv .gear/chromium src/3rdparty/
ln -s /usr/include/nspr src/3rdparty/chromium/nspr4
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%if_enabled system_icu
%patch5 -p1
%endif
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%if_enabled system_icu
%patch11 -p1
%endif
%patch12 -p1
%patch13 -p1
%patch14 -p1
#
%patch100 -p1
%patch101 -p1
%patch102 -p1
syncqt.pl-qt5 -version %version -private

# fix // in #include in content/renderer/gpu to avoid debugedit failure
sed -i -e 's!gpu//!gpu/!g' \
  src/3rdparty/chromium/content/renderer/gpu/compositor_forwarding_message_filter.cc
# and another one in 2 files in WebRTC
sed -i -e 's!audio_processing//!audio_processing/!g' \
  src/3rdparty/chromium/third_party/webrtc/modules/audio_processing/utility/ooura_fft.cc \
  src/3rdparty/chromium/third_party/webrtc/modules/audio_processing/utility/ooura_fft_sse2.cc
# remove ./ from #line commands in ANGLE to avoid debugedit failure (?)
sed -i -e 's!\./!!g' \
  src/3rdparty/chromium/third_party/angle/src/compiler/preprocessor/Tokenizer.cpp \
  src/3rdparty/chromium/third_party/angle/src/compiler/translator/glslang_lex.cpp
# delete all "toolprefix = " lines from build/toolchain/linux/BUILD.gn, as we
# never cross-compile in native Fedora RPMs, fixes ARM and aarch64 FTBFS
sed -i -e '/toolprefix = /d' -e 's/\${toolprefix}//g' \
  src/3rdparty/chromium/build/toolchain/linux/BUILD.gn
# http://bugzilla.redhat.com/1337585
# can't just delete, but we'll overwrite with system headers to be on the safe side
cp -bv /usr/include/re2/*.h src/3rdparty/chromium/third_party/re2/src/re2/

%if_enabled always_reducing_debuginfo
sed -i -e 's/symbol_level=2/symbol_level=1/g' src/core/config/common.pri
%endif
%ifnarch x86_64
# most arches run out of memory with full debuginfo, so use -g1 on non-x86_64
sed -i -e 's/symbol_level=2/symbol_level=1/g' src/core/config/common.pri
%endif

# redefine _FORTIFY_SOURCE
for f in \
    src/3rdparty/chromium/build/config/compiler/BUILD.gn \
    src/3rdparty/chromium/third_party/minigbm/src/common.mk
do
    sed -i 's|_FORTIFY_SOURCE=[[:digit:]]|_FORTIFY_SOURCE=1|g' $f
done

# generate qtwebengine-3rdparty.qdoc, it is missing from the tarball
pushd src/3rdparty
python chromium/tools/licenses.py \
  --file-template ../../tools/about_credits.tmpl \
  --entry-template ../../tools/about_credits_entry.tmpl \
  credits >../webengine/doc/src/qtwebengine-3rdparty.qdoc
popd

# copy the Chromium license so it is installed with the appropriate name
cp -p src/3rdparty/chromium/LICENSE LICENSE.Chromium

# fix find system ninja
mkdir -p bin
ln -s %_bindir/ninja-build bin/ninja

%build
export PATH=$PWD/bin:$PATH
%ifarch %ix86
# workaround against linking
mkdir -p %_target_platform/lib
ln -s ../src/core/Release/lib/libv8.so %_target_platform/lib/libv8.so
%endif
NUM_PROCS="%__nprocs"
[ -n "$NUM_PROCS" -a "$NUM_PROCS" != "1"  ] || NUM_PROCS=6
export NPROCS=$NUM_PROCS
export STRIP=strip
export NINJAFLAGS="-v -j $NUM_PROCS"
export NINJA_PATH=%_bindir/ninja-build
OPTFLAGS="%optflags"
%if_enabled always_reducing_debuginfo
export OPTFLAGS=`echo "$OPTFLAGS" | sed -e 's/ -g / -g1 /g'`
%endif
%ifnarch x86_64
# most arches run out of memory with full debuginfo, so use -g1 on non-x86_64
export OPTFLAGS=`echo "$OPTFLAGS" | sed -e 's/ -g / -g1 /g'`
%endif
export RPM_OPT_FLAGS="$OPTFLAGS"
export CFLAGS="$OPTFLAGS"

mkdir -p %_target_platform
pushd %_target_platform
%_qt5_qmake \
    QMAKE_CXXFLAGS="$CXXFLAGS" \
    CONFIG+="webcore_debug v8base_debug force_debug_info pulseaudio system-opus system-webp proprietary-codecs %qt_ffmpeg_type" \
    WEBENGINE_CONFIG+=" use_proprietary_codecs use_spellchecker" \
%if_enabled system_icu
    CONFIG+="system-icu" \
    QMAKE_EXTRA_ARGS+="-system-webengine-icu" \
%endif
%if %is_ffmpeg
    QMAKE_EXTRA_ARGS+="-system-webengine-ffmpeg" \
%endif
    ..
(while true; do date; sleep 7m; done) &
%make_build
export QT_HASH_SEED=0
make docs
popd

%install
%install_qt5 -C %_target_platform
%make INSTALL_ROOT=%buildroot install_docs -C %_target_platform ||:

%if_disabled system_icu
install -m 0644 \
    src/3rdparty/chromium/third_party/icu/common/icudtl.dat \
    %buildroot/%_qt5_datadir/resources/
%endif

# fix cmake dependencies
%IF_ver_not_eq %_qt5_version %version
sed -i -e \
  "s|%version[[:space:]][[:space:]]*\${_Qt5WebEngine\(.*_FIND_VERSION_EXACT\)|%_qt5_version \${_Qt5WebEngine\1|" \
  %buildroot/%_libdir/cmake/Qt5WebEngine*/Qt5WebEngine*Config.cmake
%endif

# find translations
echo "%%defattr(644,root,root,755)" >translations_list.lang
find %buildroot/%_qt5_translationdir/qtwebengine_locales -type f -name \*.pak | \
while read t
do
    lang_file=`basename $t`
    lang_name=`echo "$lang_file" | sed -e 's|\.pak$||' -e 's|-|_|'`
    if echo $lang_name | grep -q ^en
    then
	echo "%%_qt5_translationdir/qtwebengine_locales/$lang_file" >>translations_list.lang
    else
	echo "%%lang($lang_name) %%_qt5_translationdir/qtwebengine_locales/$lang_file" >>translations_list.lang
    fi
done

%files common -f translations_list.lang
%doc LICENSE.* LICENSE*EXCEPT*
%dir %_qt5_translationdir/qtwebengine_locales/
%dir %_qt5_datadir/resources/
%_qt5_datadir/resources/qtwebengine*.pak
%if_disabled system_icu
%_qt5_datadir/resources/*icu*
%endif

%files -n libqt5-webengine
%_qt5_libdir/libQt?WebEngine.so.*
%_qt5_qmldir/QtWebEngine/
%files -n libqt5-webenginecore
%_qt5_libdir/libQt?WebEngineCore.so.*
%ifarch %ix86
%_qt5_libdir/qtwebengine/
%endif
%_qt5_libexecdir/QtWebEngineProcess
%files -n libqt5-webenginewidgets
%_qt5_libdir/libQt?WebEngineWidgets.so.*

%files doc
%_qt5_docdir/*

%files devel
%_bindir/qwebengine_convert_dict*
%_qt5_bindir/qwebengine_convert_dict*
#
%_qt5_plugindir/designer/libqwebengineview.so
%_qt5_headerdir/QtWebEngine/
%_qt5_headerdir/QtWebEngineCore/
%_qt5_headerdir/QtWebEngineWidgets/
%_qt5_libdatadir/libQt*.so
%_qt5_libdir/libQt*.so
%_qt5_libdir/libQt*.prl
%_qt5_libdatadir/libQt*.prl
%_qt5_libdir/cmake/Qt*/
%_qt5_libdir/pkgconfig/Qt*.pc
%_qt5_archdatadir/mkspecs/modules/qt_*.pri

%changelog
