%def_enable qt4

Name:    qtcurve
Version: 1.8.15
Release: alt2
Serial:  1

Summary: QtCurve (KDE and GTK2 style)
License: GPLv2
Group:   Graphical desktop/Other
Url:     http://www.kde-look.org/content/show.php?content=40492

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Patch1: QtCurve-Gtk2-1.0.0-alt-qtrc.patch
Patch2: QtCurve-Gtk2-0.62.4-alt-icons.patch
Patch3: QtCurve-KDE3-1.0.2-alt-link-fixes.patch

BuildRequires(pre): kde-common-devel rpm-macros-qt3 rpm-macros-qt4
BuildPreReq: gcc-c++ libgtk+2-devel libqt3-devel kde4libs-devel
BuildPreReq: kde4base-workspace-devel

%description
This is a set of widget styles for KDE and GTK2 based apps.
The underlying code is based upon Blue/FreeCurve - however,
*extensive* modifications have been made.

%package -n kde4-styles-%name
Version: 1.8.14
Group:   Graphical desktop/KDE
Summary: QtCurve style for KDE 4

%description -n kde4-styles-%name
This is a set of widget styles for KDE 4

%package -n qt4-styles-%name
Version: 1.8.14
Group:   Graphical desktop/KDE
Summary: QtCurve style for Qt4
Conflicts: kde4-styles-%name

%description -n qt4-styles-%name
This is a set of widget styles for Qt4

%package -n qt3-styles-%name
Version: 1.8.5
Group:   Graphical desktop/KDE
Summary: QtCurve style for Qt3
Obsoletes: kde-styles-%name < 1.1.0-alt1
Provides: kde-styles-%name = 1.8.5-%release

%description -n qt3-styles-%name
This is a set of widget styles for Qt3

%package -n gtk2-themes-%name
Summary: The QtCurve engine for GTK2
Group:   Graphical desktop/GNOME
Provides: gtk-engines-%name
Obsoletes: gtk-engines-%name < %version-%release gtk1-themes-%name < %version-%release

%description -n gtk2-themes-%name
The QtCurve engine for GTK2

%prep
%setup
%patch1 -p1
%patch2 -p0
%patch3 -p1

%build
pushd QtCurve-KDE4
%if_enabled qt4
# Qt4
%K4cmake -DQTC_QT_ONLY:BOOL=1
%K4make
mv BUILD-%_target_platform{,-qt}
%endif
# KDE4
%K4build
popd

mkdir QtCurve-KDE3/build
pushd QtCurve-KDE3/build
# Qt3
cmake .. \
        -DCMAKE_C_FLAGS:STRING="%optflags" \
        -DCMAKE_CXX_FLAGS:STRING="%optflags"
%make_build VERBOSE=1
popd

mkdir QtCurve-Gtk2/build
pushd QtCurve-Gtk2/build
# Gtk2
cmake .. \
        -DCMAKE_C_FLAGS:STRING="%optflags"
%make_build VERBOSE=1
popd

%install
%makeinstall_std -C QtCurve-KDE4/BUILD-%_target_platform/
%makeinstall_std -C QtCurve-KDE3/build/
%makeinstall_std -C QtCurve-Gtk2/build/

%if_enabled qt4
install -pD -m644 QtCurve-KDE4/BUILD-%_target_platform-qt/style/%name.so %buildroot%_qt4dir/plugins/styles/%name.so
%endif

%files -n kde4-styles-%name
%_K4lib/*.so
%_K4plug/styles/*.so
%_K4apps/QtCurve
%_K4apps/kstyle/themes/*.themerc
%_K4apps/color-schemes/*.colors
%_K4apps/kwin/*.desktop
%doc QtCurve-KDE4/AUTHORS QtCurve-KDE4/ChangeLog QtCurve-KDE4/README QtCurve-KDE4/TODO

%if_enabled qt4
%files -n qt4-styles-%name
%dir %_qt4dir/plugins/styles/
%_qt4dir/plugins/styles/%name.so
%doc QtCurve-KDE4/AUTHORS QtCurve-KDE4/ChangeLog QtCurve-KDE4/README QtCurve-KDE4/TODO
%endif

%files -n qt3-styles-%name
%dir %_qt3dir/plugins/styles/
%_qt3dir/plugins/styles/%name.so
%doc QtCurve-KDE3/AUTHORS QtCurve-KDE3/ChangeLog QtCurve-KDE3/README QtCurve-KDE3/TODO

%files -n gtk2-themes-%name
%_libdir/gtk-2.0/*/engines/lib%name.so*
%dir %_datadir/themes/QtCurve
%_datadir/themes/QtCurve/gtk-2.0
%dir %_datadir/themes/QtCurve/mozilla
%_datadir/themes/QtCurve/mozilla/preferences-rev.xml
%_datadir/themes/QtCurve/mozilla/QtCurve.css
%_datadir/themes/QtCurve/mozilla/QtCurve-KDEButtonOrder.css
%doc QtCurve-Gtk2/AUTHORS QtCurve-Gtk2/ChangeLog QtCurve-Gtk2/README QtCurve-Gtk2/TODO


%changelog
