%def_disable rpath
%def_with pic
%def_disable devel
%def_enable debug
%def_disable warnings
%def_disable profile
%def_disable final
%def_enable mt
%def_enable threading
%def_enable shared
%def_disable static
%def_enable largefile
%def_enable ntfs
%def_enable ext3fs
%def_enable jfs
%def_enable xfs
%def_enable reiserfs
%def_enable labels


%define Name QtParted
Name: qtparted
Version: 0.7.0
Release: alt2.git20151112
Group: System/Configuration/Hardware
Summary: Flexible GUI partitioning tool
Summary(ru_RU.UTF8): Графический инструмент для работы с разделами жесткого диска
Summary(uk_UA.UTF8): Графічний інструмент для роботи з разділами жорсткого диску
License: %gpl2plus
URL: http://%name.sourceforge.net/
# https://abf.io/omv_software/qtparted.git
Source0: %name-%version.tar
Source1: %name-pam
Source2: %name-security
Source3: %{name}_ua.ts
Source4: CMakeCache.txt
Patch0: %name-0.4.5-libparted_1.7.patch
Patch1: %name-0.4.5-notable.patch
Patch2: %name-0.4.5-ide.patch
Patch3: %name-0.4.5-makefile.patch

BuildRequires: fontconfig qt5-base-devel libXext-devel libXt-devel
BuildRequires: libparted-devel libstdc++-devel gcc-c++ zlib-devel
BuildRequires: libuuid-devel ImageMagick rpm-build-licenses
BuildPreReq: e2fsprogs cmake qt5-tools-devel
BuildPreReq: qt5-designer libGL-devel libGLU-devel libjpeg-devel
BuildPreReq: libmng-devel librsvg-devel libopenmotif-devel
%{?_enable_ntfs:BuildRequires: ntfsprogs}
%{?_enable_ext3fs:BuildRequires: libe2fs-devel}
%{?_enable_jfs:BuildRequires: jfsprogs}
%{?_enable_xfs:BuildRequires: xfsprogs}
%{?_enable_reiserfs:BuildRequires: libprogsreiserfs-devel}

%description
%Name is a Partition Magic clone written in C++ using the Qt
toolkit, GUI partitioning tool. %Name is GNU Parted based. It's a
program that allows you to create, destroy, resize, move and copy hard
disk partitions. This is useful for creating space for new operating
systems, reorganising disk usage, and copying data to new hard disks.

%description -l ru_RU.UTF8
%Name является подобием программы "Partition Magic" -- инструмента
для редактирования дисковых разделов с графическим интерфейсом
пользователя. Он написан на C++ с использованием пакета Qt для
графического интерфейса и основан на программе Parted, являющейся
частью проекта GNU. Программа позволяет Вам создавать, удалять,
перемещать, копировать и изменять размер разделов жесткого диска.
%Name будет полезен при создании разделов для новых операционных
систем, при изменениях в использовании диска и копировании данных на
новый жёсткий диск.

%description -l uk_UA.UTF8
%Name є написанным на C++ з використанням тулкіта Qt клоном "Partition
Magic", графічним інструментом для роботи з розділами жорсткого диску.
%Name базується на GNU Parted. Це программа, яка дозволяє
створювати, знищувати, мереміщати, копіювати розділи, а також змінювати
їх розміри. Вона може бути корисною для створення місця для нових
операційних систем, реорганізації використання диску та копіювання
даних на новий жорсткий диск.


%prep
%setup
install -m 0644  %SOURCE3 ts/%{name}_ua.ts
install -m644 %SOURCE4 .


%build
PATH=%_qt5_bindir:$PATH \
cmake .

%make_build VERBOSE=1
#convert -resize 48x48 -depth 8 data/%{name}_{64,48}.png


%install
%makeinstall_std menudir=%_desktopdir
for s in 16 32 64; do
    install -d -m 0755 %buildroot%_iconsdir/hicolor/${s}x$s/apps
    mv %buildroot{%_datadir/%name/pics/%{name}_$s,%_iconsdir/hicolor/${s}x$s/apps/%name}.png
done
#install -D -m644 data/%{name}_48.png %buildroot%_liconsdir/%name.png

# usermode
install -pD -m640 %SOURCE1 %buildroot%_sysconfdir/pam.d/%name
install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/security/console.apps/%name
install -d -m755 %buildroot%_sbindir
mv %buildroot%_bindir/%name %buildroot%_sbindir/
ln -s %_bindir/consolehelper %buildroot%_bindir/%name

install -d %buildroot%_man1dir
install -p -m644 doc/%name.1 %buildroot%_man1dir

%find_lang %name


%files -f %name.lang
%doc AUTHORS ChangeLog doc/README doc/BUGS doc/TODO.txt
%_bindir/*
%_sbindir/*
%_sysconfdir/pam.d/*
%_sysconfdir/security/console.apps/*
%_datadir/%name
%_man1dir/*	
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*
%_desktopdir/*


%changelog
