%define _user _q3
%define _group _q3
%define _home %_localstatedir/%name

%define revision 2349

%if %_arch == x86_64
%define __arch x86_64
%else
%define __arch i386
%endif

Name: quake3
Version: 1.36
Release: alt2.svn%revision

Summary: Quake 3: Arena by ID Software
License: GPL
Group: Games/Arcade
Url: http://ioquake3.org

Source0: ioquake3-r%revision.tar.bz2

Source1: quake3.desktop
Source2: quake3.png

Source10: quake3.init
Source11: quake3.sysconfig
Source12: quake3-ctf.init
Source13: quake3-ctf.sysconfig

Patch0: quake3-alt-bug14027.patch

Packager: Igor Zubkov <icesik@altlinux.org>

Requires: %name-server = %version-%release
Requires: %name-common = %version-%release

# Automatically added by buildreq on Tue Nov 27 2012
# optimized out: libGL-devel libGLU-devel libogg-devel pkg-config
BuildRequires: libSDL-devel libcurl-devel libopenal-devel libspeex-devel libvorbis-devel zlib-devel libspeexdsp-devel

Obsoletes: quake3-client-up
Provides: quake3-client-up = %version-%release

Obsoletes: quake3-client-smp
Provides: quake3-client-smp = %version-%release

Obsoletes: quake3-client
Provides: quake3-client = %version-%release

%description
Quake 3: Arena by ID Software.

%description -l ru_RU.UTF-8
Quake 3: Arena by ID Software.
Превосходная 3D-стрелялка.

%package common
Group: Games/Arcade
Summary: Common files for Quake 3: Arena

%description common
Quake 3: Arena by ID Software.
This package contains common files.

%description common -l ru_RU.UTF-8
Quake 3: Arena by ID Software.
Этот пакет содержит общие файлы, используемые в других пакетах quake3.

%package server
Group: Games/Arcade
Summary: Quake 3: Arena dedicated server package
Requires: %name-common = %version-%release

%description server
Quake 3: Arena by ID Software.
Dedicated server.

%description server -l ru_RU.UTF-8
Quake 3: Arena by ID Software.
Выделенный сервер.

%prep
%setup -q -n ioquake3

#rm -rf code/zlib code/libspeex

rm -rf `find -name .svn` code/AL code/SDL12 code/libcurl code/libs
rm -rf code/zlib code/libspeex

# rm -rf code/jpeg-8c code/tools/lcc

%build
%make_build release V=1 \
    BUILD_CLIENT_SMP=1 \
    USE_LOCAL_HEADERS=0 \
    USE_CODEC_VORBIS=1 \
    USE_INTERNAL_SPEEX=0 \
    USE_INTERNAL_ZLIB=0

%install
mkdir -p %buildroot%_bindir/

install -p -D -m644 %SOURCE1 %buildroot%_datadir/applications/%name.desktop

cat << __EOF__ > %buildroot%_bindir/quake3
#!/bin/sh

%_libdir/quake3/ioquake3.%__arch +set sv_pure 0 +set vm_cgame 0 +set vm_game 0 +set vm_ui 0 $@
__EOF__

chmod +x %buildroot%_bindir/quake3
ln -sf %_libdir/quake3/ioq3ded.%__arch %buildroot%_bindir/q3ded

install -D -p -m 0644 %SOURCE2 %buildroot%_miconsdir/quake3.png

mkdir -p %buildroot%_libdir/quake3/baseq3/
make copyfiles COPYDIR="%buildroot%_libdir/quake3" V=1 \
    BUILD_CLIENT_SMP=1 \
    USE_LOCAL_HEADERS=0 \
    USE_CODEC_VORBIS=1 \
    USE_INTERNAL_SPEEX=0 \
    USE_INTERNAL_ZLIB=0

cat > README.ALT <<EOF
In order to actually play the game, you will need pak-files from original game
CD (pak0.pk3) plus pak-files from latest quake3 point release! Put them into
%_libdir/quake3/baseq3/!
EOF

# initscript for dedicated server
install -pDm0755 %SOURCE10 %buildroot%_initdir/%name
install -pDm0755 %SOURCE12 %buildroot%_initdir/%name-ctf
install -pDm0644 %SOURCE11 %buildroot%_sysconfdir/sysconfig/%name
install -pDm0644 %SOURCE13 %buildroot%_sysconfdir/sysconfig/%name-ctf

install -dm1700 %buildroot%_home/

%pre server
/usr/sbin/groupadd -r -f %_group ||:
/usr/sbin/useradd -g %_group -c 'The quake3 user' \
        -d %_home -s /dev/null -r %_user >/dev/null 2>&1 ||:

%post
echo "In order to actually play the game, you'll need pak-files from original game CD (pak0.pk3) plus pak-files from latest quake3 point release! Put them into %_libdir/quake3/baseq3/ or ~/.q3a/baseq3/ ! "

%post server
%post_service %name
%post_service %name-ctf
echo "In order to actually play the game, you'll need pak-files from original game CD (pak0.pk3) plus pak-files from latest quake3 point release! Put them into %_libdir/quake3/baseq3/ or ~/.q3a/baseq3/ ! "

%preun server
%preun_service %name
%preun_service %name-ctf

%files
%doc BUGS ChangeLog NOTTODO README README.ALT TODO id-readme.txt md4-readme.txt rend2-readme.txt voip-readme.txt
%_bindir/%name
%_libdir/quake3/ioquake3.%__arch
%_libdir/quake3/renderer_opengl1_%__arch.so
%_libdir/quake3/renderer_opengl1_smp_%__arch.so
%_libdir/quake3/renderer_rend2_%__arch.so
%_datadir/applications/quake3.desktop
%_miconsdir/*.png

%files common
%dir %_libdir/quake3/
%dir %_libdir/quake3/baseq3/
%_libdir/quake3/baseq3/cgame%__arch.so
%_libdir/quake3/baseq3/qagame%__arch.so
%_libdir/quake3/baseq3/ui%__arch.so
%dir %_libdir/quake3/missionpack/
%_libdir/quake3/missionpack/cgame%__arch.so
%_libdir/quake3/missionpack/qagame%__arch.so
%_libdir/quake3/missionpack/ui%__arch.so

%files server
%doc BUGS ChangeLog NOTTODO README README.ALT TODO id-readme.txt md4-readme.txt rend2-readme.txt voip-readme.txt
%_initdir/*
%_bindir/q3ded
%_libdir/quake3/ioq3ded.%__arch
%config(noreplace) %_sysconfdir/sysconfig/*
%dir %attr(1770,root,%_group) %_home

%changelog
