Name: quilt
Version: 0.60
Release: alt4

Summary: Scripts for working with series of patches
License: GPLv2+
Group: Text tools
Url: http://savannah.nongnu.org/projects/quilt/
BuildArch: noarch

Provides: bash-completion-quilt = %version-%release
Obsoletes: bash-completion-quilt
Requires: diffstat
# for quilt-rus.pdf
BuildRequires: texlive-lang-cyrillic texlive-latex-extra
# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: procmail}}
# git://git.altlinux.org/gears/q/quilt
Source: %name-%version-%release.tar

%description
The scripts allow to manage a series of patches by keeping track of
the changes each patch makes.  Patches can be applied, un-applied,
refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://userweb.kernel.org/~akpm/stuff/patch-scripts.tar.gz.

%prep
%setup -n %name-%version-%release
rm doc/*.pdf

%build
%define docdir %_docdir/%name-%version
%configure \
	--with-awk=gawk \
	--with-diffstat=diffstat \
	--with-sendmail=%_sbindir/sendmail \
	--docdir=%_docdir/%name-%version
%make_build COMPAT_SYMLINKS=sendmail RELEASE=%release
%make_build -C doc
# rerun to get right cross-references
rm doc/*.pdf
%make_build -C doc

%install
%makeinstall_std COMPAT_SYMLINKS=sendmail BUILD_ROOT=%buildroot
install -pm644 AUTHORS TODO quilt.changes doc/README.EMACS doc/*.pdf \
	%buildroot%docdir/
%find_lang %name

%check
%make_build -k check COMPAT_SYMLINKS=sendmail

%files -f %name.lang
%config(noreplace) %_sysconfdir/quilt.quiltrc
%config /etc/bash_completion.d/*
%_bindir/*
%_man1dir/*
%_datadir/%name/
%_datadir/emacs/site-lisp/*.el*
%docdir/

%changelog
