Name: rakarrack
Version: 0.6.2
Release: alt3.git20140722
Summary: Guitar effects for Linux
License: GPLv2+
Group: Sound
Url: http://rakarrack.sourceforge.net/
Source0: %name-%version.tar
Requires: %name-data = %version-%release

BuildRequires: alsa-utils gcc-c++ jackit-devel libXext-devel libXft-devel
BuildRequires: libXpm-devel libalsa-devel libfltk-devel libjpeg-devel 
BuildRequires: libpng-devel libsamplerate-devel libsndfile-devel

BuildPreReq: libpixman-devel libcairo-devel libXinerama-devel
BuildPreReq: libXfixes-devel libfftw3-devel libXcursor-devel
BuildRequires: desktop-file-utils

%description
Rakarrack is a richly featured multi-effects processor emulating a 
guitar effects pedalboard.  Effects include compressor, noise gate, 
expander, shuffle, ring, synthfilter, varyband, mutromojo, looper, arpie,
graphic equalizer, parametric equalizer, flanger, dual flange, chorus, echo 
with reverse playback, musical delay, reverb, digital phaser, analogic 
phaser, wah-wah, alien-wah, harmonizer, shifter, sequence, sustainer, 
shelfboost, vocoder, coil crafter, echoverse, convolotron, stompbox, 
exciter and four flexible distortion modules including sub-octave modulation 
and dirty octave up.  Most of the effects engine is built from modules 
found in the excellent software synthesizer ZynAddSubFX.  Presets and 
user interface are optimized for guitar, but Rakarrack processes signals 
in stereo while it does not apply internal band-limiting filtering, 
and thus is well suited to all musical instruments and vocals.  
Rakarrack is designed for Linux distributions with Jack Audio Connection Kit.

%package data
Summary: Data files and documentation for Rakarrack
Group: Sound
BuildArch: noarch

%description data
This package contains data files and documentation for Rakarrack.

%prep
%setup

%build
%autoreconf

%configure \
%ifarch x86_64
	--enable-sse \
	--enable-sse2 \
%endif
	--enable-jack-session \
	--enable-datadir=yes \
	--enable-docdir=yes

%make_build

%install
%makeinstall_std
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Music \
	%buildroot%_desktopdir/rakarrack.desktop

%files
%_bindir/*

%files data
%_desktopdir/%name.desktop
%_man1dir/%name.1.gz
%_pixmapsdir/*
%_datadir/%name
%_datadir/doc/%name

%changelog
