%def_disable snapshot
%define rev r1
%if_enabled snapshot
%define git_distance 1175
%endif

Name: rawtherapee
Version: 5.0%{?_enable_snapshot:.%git_distance}
Release: alt0.r1.M80P.1

Summary: THe Experimental RAw Photo Editor
License: GPLv3+
Group: Graphics
URL: http://www.rawtherapee.com/

%if_enabled snapshot
# use full archive not git-archive to avoid dancing around version
Source: rawtherapee-%version.tar
%else
Source: http://rawtherapee.com/shared/source/%name-%version-%rev-gtk3.tar.xz
%endif

Requires: %name-data = %version-%release

%{?_enable_snapshot:BuildRequires: git}
BuildRequires: bzlib-devel cmake gcc-c++ libgomp-devel libgtkmm3-devel libiptcdata-devel
BuildRequires: libjpeg-devel liblcms2-devel libpng-devel libtiff-devel libfftw3-devel
BuildRequires: libexpat-devel libpixman-devel libcanberra-gtk3-devel
BuildRequires: libXdmcp-devel libXdamage-devel libXxf86vm-devel
BuildRequires: libexiv2-devel libharfbuzz-devel

%description
Raw Therapee is a free RAW converter and digital photo processing software.

%package data
Summary: Arch independent files for Raw Therapee
Group: Graphics
BuildArch: noarch

%description data
This package provides noarch data needed for Raw Therapee to work.

%prep
%setup -n %name-%version-%rev-gtk3
# Do not install useless rtstart:
subst "s|install (PROGRAMS rtstart|\#install (PROGRAMS rtstart|" CMakeLists.txt

%build
%cmake -DCMAKE_BUILD_TYPE:STRING="Release" \
	-DCMAKE_CXX_FLAGS="-std=c++11" \
	-DCACHE_NAME_SUFFIX=""
%cmake_build VERBOSE=1

%install
%cmakeinstall_std

rm -f %buildroot/%_datadir/doc/rawtherapee/*.txt

%files
%_bindir/%name
%doc AUTHORS.txt LICENSE.txt RELEASE_NOTES.txt

%files data
%_desktopdir/%name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/apps/*
%_man1dir/%name.1.*
%_datadir/appdata/%name.appdata.xml

%changelog
