Name: readline5
%define rl_version 5.2
%define rl_patch 14
%define srcname readline-%rl_version
Version: %rl_version.%rl_patch
Release: alt5.1

Summary: A library for editing typed in command lines
License: GPLv2+
Group: System/Libraries
Url: http://www.gnu.org/software/readline/

# ftp://ftp.gnu.org/gnu/readline/readline-%rl_version.tar.gz
# ftp://ftp.gnu.org/gnu/readline/readline-%rl_version-patches/
Source: readline-%version.tar

Patch: readline-%version-%release.patch

# Automatically added by buildreq on Mon Sep 02 2002
BuildRequires: libtinfo-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%package -n lib%name
Summary: A library for editing typed in command lines
Group: System/Legacy libraries
Obsoletes: readline
Provides: readline = %version-%release
Obsoletes: libreadline < %version-%release
Provides: libreadline = %version-%release

%package -n lib%name-devel
Summary: Files needed to develop programs which use the readline library
Group: Development/C
Obsoletes: readline-devel
PreReq: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: Files needed to develop statically linked programs which use the readline library
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

%description -n lib%name
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

%description -n lib%name-devel
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

This package contains the files needed to develop programs which use
the readline library to provide an easy to use and more intuitive
command line interface for users.

%description -n lib%name-devel-static
The readline library reads a line from the terminal and returns it,
allowing the user to edit the line with standard emacs editing keys.

This package contains the files needed to develop statically linked
programs which use the readline library to provide an easy to use
and more intuitive command line interface for users.

%prep
%setup -q -n readline-%version
%patch -p1

%build
# This is required to fix some "implicit declaration" warnings.
%add_optflags -D_GNU_SOURCE

# Link with libtinfo unconditionally.
export bash_cv_termcap_lib=libtinfo

# Workaround for buildreq/strace.
%{?__buildreqs:export bash_cv_must_reinstall_sighandlers=no}

# Fix temporary file handling.
sed -i 's,/tmp/,,g' *.m4
autoconf

%configure
rm doc/*.info

%make_build all examples documentation

%install
%makeinstall_std

# Relocate shared libraries from %_libdir/ to /%_lib/.
soname=$(readlink "%buildroot%_libdir/libreadline.so")
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# Replace libreadline.so symlink with a linker script.
rm %buildroot%_libdir/libreadline.so
cat >%buildroot%_libdir/libreadline.so <<__EOF__
/* GNU ld script */
GROUP(/%_lib/$soname AS_NEEDED(-lhistory))
__EOF__

# Relocate and fix documentation.
%define docdir %_docdir/readline-%version
mkdir -p %buildroot%docdir
cp -a README CHANGE* USAGE examples \
	%buildroot%docdir/
bzip2 -9 %buildroot%docdir/CHANGE*
cp -p config.h posixstat.h xmalloc.h \
	%buildroot%docdir/examples/
pushd %buildroot%docdir/examples
	sed -i 's,\.\./shlib/lib\([^.]\+\)\.so,-l\1,' Makefile
	sed -i 's,^\(top_srcdir *=\).*,\1 %_includedir/readline,g;s,^\(LDFLAGS *=\).*,\1,g' Makefile
	make clean
popd

%set_verify_elf_method strict

%files -n lib%name
/%_lib/*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_mandir/man?/*
%_infodir/*.info*
%docdir

%files -n lib%name-devel-static
%_libdir/*.a

%changelog
