%def_with inotify
%def_without fam
%def_enable qtgui
%def_enable webkit

%define pre %nil

Name: recoll
Version: 1.24.1
Release: alt1.M80P.1

Summary: A personal full text search package
License: %gpl2plus
Group: File tools

Url: http://www.recoll.org
Source0: %url/%name-%version%pre.tar.gz
Source1: recoll_ru.ts
Source2: recoll_ru.qm
Source3: recoll_uk.ts
Source4: recoll_uk.qm
# 1.24.1+ru
Source5: recoll-searchgui.desktop
Source100: recoll.watch

# fix FTBFS against Qt 5.11
# https://opensourceprojects.eu/p/recoll1/tickets/52/
Patch: recoll-1.24.1-qt5.11-build.patch

Packager: Michael Shigorin <mike@altlinux.org>

BuildRequires: gcc-c++ libaspell-devel ImageMagick
%{?_with_fam:BuildRequires: libfam-devel}
BuildRequires: libxapian-devel >= 0.9
BuildRequires: rpm-build-licenses
BuildRequires: perl-Image-ExifTool
BuildRequires: python-devel
BuildRequires: zlib-devel
BuildRequires: libaspell-devel

%if_enabled qtgui
BuildRequires: qt5-base-devel qt5-x11extras-devel qt5-tools-devel libXt-devel xorg-cf-files
%if_enabled webkit
BuildRequires: qt5-webkit-devel
%endif
%endif

%add_findreq_skiplist %_datadir/%name/filters/*
%add_findreq_skiplist %_datadir/%name/examples/*

%description
Recoll is a personal full text search package based on a very strong
backend (Xapian), for which it provides an easy to use, feature-rich,
easy administration interface.

See also recoll-extras package for somewhat more exotic stuff.
%if_disabled qtgui

Note that this package has been built without its usual GUI.
%endif

%package extras
Summary: More helper scripts for Recoll
Group: File tools
Requires: %name = %version
BuildArch: noarch

%description extras
This package contains additional helper scripts for recoll which might
need bulky additional required packages, manual setup, or both.

%package full
Summary: All the recommended stuff for Recoll
Group: File tools
BuildArch: noarch
Requires: %name-extras = %version
Requires: perl-Image-ExifTool
Requires: antiword catdoc unrtf
Requires: python-module-pychm
Requires: aspell aspell-ru-rk
Requires: xpdf-utils ghostscript-utils

%description full
This package contains just the requirements for additional packages
that might be of use with Recoll.

%package -n python-module-%name
Summary: Python bindings for Recoll
Group: Development/Python

%description -n python-module-%name
This package contains Python bindings for Recoll.

%prep
%setup -n %name-%version%pre
%patch -p2

sed -i 's/openoffice/loffice/' sampleconf/mimeview
sed -i '/^Categories=/s/=/=Qt;/' desktop/*.desktop
# updated translations: ru
cp -a %SOURCE1 %SOURCE2 qtgui/i18n/
cp -a %SOURCE5 desktop/

%build
export CXXFLAGS="%optflags" PATH="$PATH:%_libdir/qt5/bin"
export QMAKE=qmake-qt5
%configure \
	%{subst_with inotify} \
	%{subst_with fam} \
	%{subst_enable qtgui} \
	%{subst_enable webkit} \
	#
%make_build
gzip --best --keep --force ChangeLog
for s in 128 96 72 64 36 32 24 22 16; do
    convert -depth 8 -resize ${s}x$s desktop/%name{.xcf,-$s.png}
done

%install
%makeinstall_std INSTALL_ROOT=%buildroot
for s in 128 96 72 64 36 32 24 22 16; do
    install -pDm644 desktop/%name-$s.png %buildroot%_iconsdir/hicolor/${s}x$s/apps/%name.png
done
sed -i 's/xterm/xvt/g' %buildroot%_datadir/%name/filters/*

# use /usr/bin/xdg-open
rm -f %buildroot%_datadir/%name/filters/xdg-open

%files
%_bindir/*
%_libdir/%name
%_datadir/%name
%exclude %_datadir/%name/filters/rcllyx
%exclude %_datadir/%name/filters/*.py
%exclude %_datadir/%name/filters/*.zip
%if_enabled qtgui
%_datadir/appdata/*
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*
%_desktopdir/*
%endif
%_man1dir/*
%_man5dir/*
%doc ChangeLog.* README

%files extras
%_datadir/%name/filters/rcllyx
%_datadir/%name/filters/*.py
%_datadir/%name/filters/*.zip

%files full

%files -n python-module-%name
%python_sitelibdir/%name/
%python_sitelibdir/*.egg-info

%changelog
