Name: redis
Version: 3.0.7
Release: alt2

Summary: Redis is an advanced key-value store

Group: System/Libraries
License: New BSD License
Url: http://redis.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://redis.googlecode.com/files/%name-%version.tar

Source1: %name.conf
Source2: redis-benchmark.1
Source3: redis-cli.1
Source4: redis-server.1
Source5: redis-cli.bash_completion
Source6: redis-server.logrotate
Source7: redis.init
Source8: redis.sysconfig
Source9: redis.service

Patch: fix_CVE-2019-10192.patch

# for check section
BuildPreReq: tcl >= 8.5

# Automatically added by buildreq on Sun Oct 25 2015
BuildRequires: git-core xsltproc

%description
Redis is an advanced key-value store. It is similar to memcached but
the dataset is not volatile, and values can be strings, exactly like in
memcached, but also lists, sets, and ordered sets. All this data types can
be manipulated with atomic operations to push/pop elements, add/remove
elements, perform server side union, intersection, difference between
sets, and so forth. Redis supports different kind of sorting abilities.

In order to be very fast but at the same time persistent the whole dataset
is taken in memory, and from time to time saved on disc asynchronously
(semi persistent mode) or alternatively every change is written into an
append only file (fully persistent mode). Redis is able to rebuild the
append only file in background when it gets too big.

Redis supports trivial to setup master-slave replication, with very
fast non-blocking first synchronization, auto reconnection on net split,
and so forth.

Redis is written in ANSI C and works in most POSIX systems like Linux,
*BSD, Mac OS X, Solaris, and so on. Redis is free software released under
the very liberal BSD license. Redis is reported to compile and work
under WIN32 if compiled with Cygwin, but there is no official support
for Windows currently.

%define redis_user      _redis
%define redis_group     _redis

%prep
%setup
%patch -p1
sed -e 's|\$(CCOPT) \$(DEBUG) \$(OBJ)|\$(OBJ) \$(CCOPT) \$(DEBUG)|g' -i src/Makefile

%build
%make_build CXXFLAGS="%{optflags}" CFLAGS="%{optflags}"

%install
%makeinstall_std PREFIX=%buildroot%prefix
mkdir -p %buildroot%_sbindir/
mkdir -p %buildroot%_sysconfdir/%name
install -m644 %SOURCE1 %buildroot%_sysconfdir/%name/
mv %buildroot%_bindir/redis-server %buildroot%_sbindir/
mv %buildroot%_bindir/redis-sentinel %buildroot%_sbindir/

mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_logdir/%name

mkdir -p %buildroot%_man1dir
install -m 644 %SOURCE2 %buildroot%_man1dir/
install -m 644 %SOURCE3 %buildroot%_man1dir/
install -m 644 %SOURCE4 %buildroot%_man1dir/

mkdir -p %buildroot%_sysconfdir/bash_completion.d
install -m 644 %SOURCE5 %buildroot%_sysconfdir/bash_completion.d/redis-cli

mkdir -p %buildroot%_logrotatedir
install -m 640 %SOURCE6 %buildroot%_logrotatedir/redis-server

mkdir -p  %buildroot%_initdir
install -m 0755 %SOURCE7 %buildroot%_initdir/%name

mkdir -p %buildroot%_sysconfdir/sysconfig
install -m 0640 %SOURCE8 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p  %buildroot%_unitdir
install -m 0644 %SOURCE9 %buildroot%_unitdir/%name.service

mkdir -p  %buildroot%_tmpfilesdir
echo 'd /var/run/%name 0775 root %redis_group' >> %buildroot%_tmpfilesdir/%name.conf

%pre
# Add the "_redis" user
%_sbindir/groupadd -r -f %redis_group 2>/dev/null ||:
%_sbindir/useradd  -r -g %redis_group -c 'Redis daemon' \
        -s /dev/null -d /var/lib/redis %redis_user 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc COPYING 00-RELEASENOTES README BUGS

%attr(0750,root,%redis_group) %dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/redis.conf

%config %_logrotatedir/redis-server
%config %_sysconfdir/bash_completion.d/redis-cli
%attr(0750,root,%redis_group) %config(noreplace) %_sysconfdir/sysconfig/%name
%config %_initdir/%name
%_unitdir/%name.service
%_tmpfilesdir/%name.conf

%_bindir/redis-check-aof
%_bindir/redis-check-dump
%_bindir/redis-cli
%_bindir/redis-benchmark
%_sbindir/redis-server
%_sbindir/redis-sentinel

%_man1dir/*

%attr(0770,root,%redis_group) %dir %_localstatedir/%name
%attr(1770,root,%redis_group) %dir %_logdir/%name


%changelog
