%def_without telepathy

Name: remmina
Version: 1.2.0
Release: alt6.rc21
Summary: Remote Desktop Client

Group: Networking/Remote access
License: GPLv2+ and MIT
Url: http://remmina.sourceforge.net
Source: %name-%version.tar
Source1: ru.po
Patch0: remmina-1.2.0-rdp-passwordispin_option.patch
Patch1: fix_plugins_search_v1.2.0-rc21.patch
Patch2: alt-libssh0.8.patch

Requires: icon-theme-hicolor

BuildRequires: cmake
BuildRequires: desktop-file-utils
BuildRequires: gettext pkgconfig(libpcre)
BuildRequires: intltool
BuildRequires: libappstream-glib
BuildRequires: libgcrypt-devel
BuildRequires: libjpeg-devel libtasn1-devel libpng-devel libpixman-devel zlib-devel
BuildRequires: pkgconfig(glib-2.0) >= 2.28 pkgconfig(gio-2.0) pkgconfig(gobject-2.0) pkgconfig(gmodule-2.0) pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(avahi-ui) >= 0.6.30
BuildRequires: pkgconfig(avahi-ui-gtk3) >= 0.6.30
BuildRequires: pkgconfig(freerdp2) >= 2.0.0
BuildRequires: pkgconfig(winpr2)
BuildRequires: pkgconfig(gtk+-3.0) pkgconfig(gdk-pixbuf-2.0) pkgconfig(pango) pkgconfig(cairo) pkgconfig(atk)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: pkgconfig(libssh) >= 0.6
BuildRequires: pkgconfig(libvncserver)
%{?_with_telepathy:BuildRequires: pkgconfig(telepathy-glib)}
BuildRequires: pkgconfig(vte-2.91)
BuildRequires: pkgconfig(xkbfile)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(spice-client-gtk-3.0)

%add_findreq_skiplist %_datadir/%name/external_tools/*

%description
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny netbooks.

Remmina supports multiple network protocols in an integrated and consistent
user interface. Currently RDP, VNC, XDMCP and SSH are supported

%package devel
Summary: remmina development headers
Group: Development/Other

%description devel
Files required to build plugins for remmina

%package plugins
Summary: A set of plugins for remmina
Group: Networking/Remote access
Requires: %name freerdp-plugins-standard

%description plugins
A set of plugins for %name remote desktop client

%package plugins-gnome
Summary: A set of plugins-gnome for remmina
Group: Networking/Remote access
Requires: %name-plugins

%description plugins-gnome
A set of plugins-gnome for %name remote desktop client

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1

#? Hack: https://github.com/FreeRDP/Remmina/issues/292
sed -i 's#install(DIRECTORY include/remmina DESTINATION include/remmina #install(DIRECTORY remmina/include/remmina DESTINATION include/ #' CMakeLists.txt
cp -f %SOURCE1 remmina/po/

%build
%cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DWITH_APPINDICATOR=OFF \
    -DWITH_AVAHI=ON \
    -DWITH_FREERDP=ON \
    -DWITH_GCRYPT=ON \
    -DWITH_GETTEXT=ON \
    -DWITH_LIBSSH=ON \
     %{?_without_telepathy:-DWITH_TELEPATHY=OFF} \
    -DWITH_VTE=ON \
    -DREMMINA_PLUGINDIR=%_libdir/remmina/plugins

%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_pkgconfigdir
install -p -m 644 remmina/%name.pc.in %buildroot%_pkgconfigdir/%name.pc

subst "s|@prefix@|%_prefix|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@exec_prefix@|%_exec_prefix|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@libdir@|%_libdir|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@includedir@|%_includedir|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@VERSION@|%version|g" %buildroot%_pkgconfigdir/%name.pc

%find_lang %name

%files -f %name.lang
%doc AUTHORS CHANGELOG.md README.md
%_bindir/%name
%_datadir/metainfo/*.appdata.xml
%_datadir/mime/*/*.xml
%_datadir/applications/*.desktop
%_iconsdir/*/*/*/*
%_datadir/%name
%dir %_libdir/remmina
%dir %_libdir/remmina/plugins

%files plugins
%_libdir/remmina/plugins/*.so
%exclude %_libdir/remmina/plugins/remmina-plugins-gnome.so

%files plugins-gnome
%_libdir/remmina/plugins/remmina-plugins-gnome.so

%files devel
%_includedir/%name
%_pkgconfigdir/*

%changelog
