Name: repocop
Version: 0.80
Release: alt1
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: Repocop is a repository unit tests platform.
Group: Development/Other
License: GPL or Artistic
Url: http://repocop.altlinux.org

Source: %name-%version.tar

Provides: repocop-collector-rpm = 0.01

# Recommends, not requires fakeroot
Requires: fakeroot >= 1.9
# pax is preferred over cpio due to correct unpacking for unreadable directories
Requires: pax
BuildRequires: perl-devel perldoc perl-autodie
BuildRequires: perl(Data/Array2ArrayMap/Hash/XSTree.pm)
BuildRequires: perl(RPM/Header.pm) perl(RPM/Vercmp.pm) perl-DBD-SQLite
BuildRequires: perl-RPM-Source-Editor
BuildRequires: perl-File-Lock-ParentLock
BuildRequires: perl-HTML-Template-Pro
BuildRequires: perl(Source/Shared/CLI.pm) perl(Source/Shared/Resource/Verbose.pm)
Requires: perl-DBD-SQLite sqlite3

# obsolete repocop-sqlite interface
Conflicts: repocop-unittest-unmet-dependency < 0.04
# statedir
Conflicts: repocop-collector-specfile < 0.04

%description
Repocop is a repository unit tests platform.
It provides a framework for running integration tests
(unit tests) for a set of rpm files (or the whole repository).

Test results are cached, so tests are run only if necessary.

Note that tests are separate packages: repocop is a platform,
it itself contains no tests. This package contains only
the test runner, repocop-run, internal utils and the set
of report generators.
For example, to get html report of test results, run
repocop-report-html with whe same arguments as repocop-run.

%package tools
Group: Development/Other
Summary: repocop tools for auto repairing repocop packages
Conflicts: repocop < 0.78
Requires: perl-RPM-Source-Editor > 0.9215
Requires: %name = %version-%release

%description tools
%summary

%package resource-html
Group: Development/Other
Summary: repocop report in HTML form.
Conflicts: repocop < 0.79

%description resource-html
Repocop is a repository unit tests platform.
This package provides common resources for various repocop based HTML reports.

%package report-html
Group: Development/Other
Summary: repocop report in HTML form.
Conflicts: repocop < 0.79
Requires: repocop-resource-html = %EVR

%description report-html
Repocop is a repository unit tests platform.
This package provides repocop HTML reports.

%prep
%setup

%build
%perl_vendor_build

%install
%perl_vendor_install

for i in \
  %_datadir/repocop/pkgtests \
  %_datadir/repocop/srctests \
  %_datadir/repocop/pkgcollectors \
  %_datadir/repocop/srccollectors \
  %_datadir/repocop/sqlite-functions \
  %_datadir/repocop/common \
; do mkdir -p $RPM_BUILD_ROOT$i
done
mkdir -p $RPM_BUILD_ROOT%_datadir/repocop/pkgcollectors/rpm/
install -m644 pkgcollectors/rpm/*.sql.* $RPM_BUILD_ROOT%_datadir/repocop/pkgcollectors/rpm/

mkdir -p $RPM_BUILD_ROOT%_datadir/repocop/fixscripts/
#install -m644 fixscripts/*.pl $RPM_BUILD_ROOT%_datadir/repocop/fixscripts/

install -m755 common/* $RPM_BUILD_ROOT%_datadir/repocop/common/

mkdir -p $RPM_BUILD_ROOT%_datadir/repocop/html/
install -m644 img/* $RPM_BUILD_ROOT%_datadir/repocop/html/

for backend in fsprefix fsmd5prefix ; do
    mkdir -p %buildroot%_prefix/libexec/repocop/backends/$backend
    cp -a libexec/backends/$backend/repocop-test-* %buildroot%_prefix/libexec/repocop/backends/$backend/
done

%files
#doc README ChangeLog
%_bindir/repocop-*
%_man1dir/repocop-*
# not supported yet
%exclude %_bindir/repocop-check-against-repository
# report-html
%exclude %_bindir/repocop-report-html
%exclude %_man1dir/repocop-report-html.*
# resource-html
%exclude %perl_vendor_privlib/Test/Repocop/Report/HTML.pm
# tools
%exclude %_bindir/repocop-report-diff
%exclude %_man1dir/repocop-report-diff.*
%exclude %_bindir/repocop-tools-*
%exclude %_man1dir/repocop-tools-*
%exclude %_bindir/repocop-nmu-*
%exclude %_man1dir/repocop-nmu-*
%exclude %perl_vendor_privlib/Test/Repocop/RepocopResource.pm
%exclude %perl_vendor_privlib/Test/Repocop/FixscriptFactory.pm
%dir %_datadir/repocop/pkgtests
%dir %_datadir/repocop/srctests
%dir %_datadir/repocop/pkgcollectors
%dir %_datadir/repocop/srccollectors
%dir %_datadir/repocop/sqlite-functions
%_datadir/repocop/common
%perl_vendor_privlib/T*
#perl_vendor_man3dir/*
%_datadir/repocop/pkgcollectors/rpm
%_prefix/libexec/repocop

%files tools
#doc fixscripts/*.pl
%dir %_datadir/repocop/fixscripts
%_bindir/repocop-tools-*
%_man1dir/repocop-tools-*
%_bindir/repocop-report-diff
%_man1dir/repocop-report-diff.*
%_bindir/repocop-nmu-*
%_man1dir/repocop-nmu-*
%perl_vendor_privlib/Test/Repocop/RepocopResource.pm
%perl_vendor_privlib/Test/Repocop/FixscriptFactory.pm

%files resource-html
%_datadir/repocop/html
%perl_vendor_privlib/Test/Repocop/Report/HTML.pm

%files report-html
%_bindir/repocop-report-html
%_man1dir/repocop-report-html.*

%changelog
