%define testname sisyphus_check-check-gpg
%define sisyphus_check_ver 0.8.7
%define sisyphus_check_rel alt1
Name: repocop-unittest-%testname
Version: 0.5.%sisyphus_check_ver
# we should bump release at every sisyphus_check release
Requires: sisyphus_check >= %sisyphus_check_ver-%sisyphus_check_rel
Release: %sisyphus_check_rel
BuildArch: noarch
Packager: Igor Yu. Vlasenko <viy@altlinux.org>

Summary: %testname intergration test for repocop test platform
Group: Development/Other
License: GPL or Artistic
Url: http://repocop.altlinux.org 
Requires: repocop

%description
%testname intergration test for repocop test platform.
The test checks packages using sisyphus_check utility for the 
following sisyphus_check tests: gpg, buildhost, buildtime.

Note that this test is only for the very old packages in Sisyphus 
that are kept there from the ancient times before the hasher 
was even invented. Newer packages that have passed through 
the hasher should always pass those tests.

The test is not recommended for general use.

%prep

%build
cat > sisyphus_check-check-gpg.test <<'EOF'
#!/bin/bash
if sisyphus_check --verbose --files --no-check=ALL \
--check-gpg --check-buildhost --check-buildtime \
$REPOCOP_PKG > $REPOCOP_TEST_TMPDIR/msg 2>&1; then
    exec repocop-test-ok
else
    exec repocop-test-warn "package need a rebuild: it is too old, so that sisyphus_check complains: " `cat $REPOCOP_TEST_TMPDIR/msg`;
fi
EOF

%install
mkdir -p $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/
%__install -m 755 %testname.test $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/test
cat > $RPM_BUILD_ROOT%_datadir/repocop/pkgtests/%testname/options <<EOF
need_unpack=0
EOF

%files
#doc README ChangeLog
%_datadir/repocop/pkgtests/%testname

%changelog
