%define svn svn17640
# Apache1 setup
%define webusr apache
%define webgrp apache
# Apache2 setup
%define webusr2 apache2
%define webgrp2 webmaster
%define rtname rt
%define fullrtname request-tracker
# Database setup
%define dbhost localhost
%define mysql_dba    root
%define pgsql_dba    postgres
%define oracle_dba    system
%define sqlite_dba    root

%define dbname %rtname
%define dbuser %rtname

%define wwwroot %webserver_webappsdir

Summary: Request Tracker (RT) is an enterprise-grade issue tracking system
Name: %fullrtname
Version: 3.8.17
Release: alt3
Group: Networking/WWW
License: GPL
Url: http://www.bestpractical.com/rt/
BuildArch: noarch

# Obsolete old names
Obsoletes: rt

Source0: %name-%version.tar

%add_findreq_skiplist */bin/webmux.pl 
%add_findreq_skiplist */lib/RT/Config.pm
%add_findreq_skiplist */sbin/rt-setup-database
%add_findreq_skiplist */lib/RT/Test/*
%add_findreq_skiplist */lib/RT/Test.pm
%add_findreq_skiplist */lib/RT/Handle.pm
%add_findreq_skiplist */lib/RT/I18N/i_default.pm
%add_findreq_skiplist */lib/RT/Search.pm
%add_findreq_skiplist */lib/RT/Search/*

%define _perl_lib_path %_libexecdir/%rtname/lib/

%define siteconfig %_sysconfdir/%rtname/RT_SiteConfig.pm

# Apache1 and mod_fastcgi
%define apacheconfig %_sysconfdir/httpd/conf/vhosts.d/%rtname.conf.example
# Apache2 and mod_perl
# FIXME Where should i put this?
%define apache2config %_sysconfdir/httpd2/conf/%rtname.conf.example

# Common packages
Requires: smtpd
# Perl modules
Requires: perl(CGI.pm) >= 3.350
Requires: perl(DBIx/SearchBuilder.pm) >= 1.510
Requires: perl(Text/Quoted.pm) >= 2.020
Requires: perl(Module/Versions/Report.pm) >= 1.030
Requires: perl(Text/Quoted.pm) >= 2.05
# Manual
Requires: perl(Data/ICal.pm)
# Main package is builded with mysql support
Requires: perl(DBD/mysql.pm)

Requires: perl(Term/ReadKey.pm)
Requires: perl(FCGI.pm)
Requires: perl(Apache/Session/Postgres.pm)
Requires: perl(CSS/Squish.pm)
Requires: perl(Calendar/Simple.pm)
Requires: perl(Mouse.pm)

BuildRequires(pre): rpm-build-fonts rpm-build-webserver-common

# Automatically added by buildreq on Wed Jul 16 2008 (-ba)
BuildRequires: gnupg perl-Apache-Session perl-CPAN perl-CSS-Squish perl-Calendar-Simple perl-DBD-mysql perl-DBIx-SearchBuilder perl-Data-ICal perl-DateTime-TimeZone perl-Email-Address perl-FCGI perl-File-ShareDir perl-GnuPG-Interface perl-GraphViz perl-HTML-Format perl-HTML-RewriteAttributes perl-HTML-Scrubber perl-HTTP-Server-Simple-Mason perl-IPC-Run-SafeHandles perl-Locale-Maketext-Fuzzy perl-Locale-Maketext-Lexicon perl-Log-Agent perl-Log-Dispatch perl-MIME-Types perl-MIME-tools perl-Mail-SpamAssassin perl-Module-Versions-Report perl-Net-Server perl-PerlIO-eol perl-Regexp-Common perl-Term-ReadKey perl-Test-HTTP-Server-Simple perl-Test-WWW-Mechanize perl-Text-Quoted perl-Text-Template perl-Text-WikiFormat perl-Text-Wrapper perl-Time-modules perl-Tree-Simple perl-UNIVERSAL-require perl-XML-RSS perl-XML-Simple perl-capitalization sendmail-common perl(Pod/Text.pm) perl(Pod/Select.pm) perl(CPAN/Meta/Requirements.pm) perl(Data/Perl/Role/Collection/Array.pm) perl(CGI/Fast.pm)
BuildRequires: perl-FCGI-ProcManager fonts-ttf-google-droid-sans
# build fix by hiddenman
BuildRequires: perl-Mouse perl-GD perl-GD-Graph perl-GD-Text perl-Devel-GlobalDestruction perl-IPC-Run perl-CGI-Emulate-PSGI perl-Plack perl-Convert-Color perl-HTML-Quoted perl-Regexp-IPv6 perl-IPC-Run perl-HTML-Mason-PSGIHandler perl-CGI-PSGI perl-Regexp-Common-net-CIDR perl-IPC-Run3 perl-JSON perl-Text-Password-Pronounceable perl-Starlet perl-Parallel-Prefork

%description
Request Tracker (RT) is an enterprise-grade issue tracking system. It allows
organizations to keep track of their to-do lists, who is working
on which tasks, what's already been done, and when tasks were
completed. It is available under the terms of version 2 of the GNU
General Public License (GPL), so it doesn't cost anything to set
up and use.

Built with options:
     --with-db-type=mysql
     --with-db-host=%dbhost
     --with-db-dba=%mysql_dba --with-db-rt-user=%dbuser
     --with-db-database=%dbname
     --with-web-user=%webusr --with-web-group=%webgrp

%package apache
Summary: Apache 1.x support the %name
Group: Networking/WWW
Requires: %name = %version
Requires: apache-common
Requires: mod_fastcgi

%description apache
%summary

%package apache2
Summary: Apache 2.x support the %name
Group: Networking/WWW
Requires: %name = %version
Requires: apache2-common
Requires: apache2-mod_perl

%description apache2
%summary

%package postgresql
Summary: PostgreSQL support for the %name
Group: Networking/WWW
Requires: %name = %version
Requires: perl(DBD/Pg.pm)

%description postgresql
%summary

#%%package oracle
#Summary: Oracle support for the %name
#Group: Networking/WWW
#Requires: %name = %version
#Requires: perl(DBD/Oracle.pm)

#%%description oracle
#%%summary

%package sqlite
Summary: SQLite support for the %name
Group: Networking/WWW
Requires: %name = %version
Requires: perl(DBD/SQLite.pm)

%description sqlite
%summary


%prep

# now the normal stuff
%setup

cat <<EOF >>config.layout
<Layout ALT>
  prefix:              %_prefix
  exec_prefix:         %_prefix
  bindir:              %_libexecdir/%rtname/bin
  sbindir:             %_libexecdir/%rtname/sbin
  sysconfdir:          %_sysconfdir/%rtname
  datadir:             %_datadir
  libdir:              %_libexecdir/%rtname/lib
  mandir:              %_mandir
  vardir:              %_var
  htmldir:             %wwwroot/%rtname
  fontdir:             %wwwroot/%rtname/fonts
  manualdir:           %_defaultdocdir/%rtname-%version
  localstatedir:       %_localstatedir/%rtname/
  logfiledir:          %_logdir/%rtname
  masonstatedir:       %_localstatedir/%rtname/cache/mason_data
  sessionstatedir:     %_localstatedir/%rtname/cache/session_data
  customdir:           %_libexecdir/%rtname/local
  customdir2:          %wwwroot/%rtname/local
  custometcdir:        %_libexecdir/%rtname/local/etc
  customhtmldir:       %wwwroot/%rtname/local/html
  customlexdir:        %_libexecdir/%rtname/local/po
  customlibdir:        %_libexecdir/%rtname/local/lib
</Layout>
EOF

%build

#sed -i "s/\[3.8.0\]/\[%version\]/g" ./configure.ac
%autoreconf
%configure --enable-layout=ALT \
	    --enable-graphviz \
	    --enable-gpg \
            --with-db-type=mysql \
            --with-db-host=%dbhost \
            --with-db-dba=%mysql_dba --with-db-rt-user=%dbuser \
            --with-db-database=%dbname \
            --with-web-user=%webusr --with-web-group=%webgrp \
            --with-apachectl=%_sbindir/apachectl

%install
make DESTDIR=%buildroot install

mkdir -p %buildroot%_localstatedir/%rtname/cache/mason_data/{cache,etc,obj}
mkdir -p %buildroot%_localstatedir/%rtname/cache/session_data
mkdir -p %buildroot%_localstatedir/%rtname/data/gpg

mkdir -p %buildroot%wwwroot/%rtname/local/html
mkdir -p %buildroot%wwwroot/%rtname/RTx
mkdir -p %buildroot%_libexecdir/%rtname/bin
mkdir -p %buildroot%_libexecdir/%rtname/lib/RTx
mkdir -p %buildroot%_libexecdir/%rtname/local/{etc,po,lib}

# apache config
mkdir -p %buildroot%_sysconfdir/httpd/conf/vhosts.d
cp altlinux/%rtname-apache-vhost.conf %buildroot%apacheconfig

# apache2 config
mkdir -p %buildroot%_sysconfdir/httpd2/conf/
cp altlinux/%rtname-apache2-vhost.conf %buildroot%apache2config

# rt-remind,rt-count and rt-escalate scripts
cp altlinux/%rtname-rt-remind %buildroot%_libexecdir/%rtname/bin/rt-remind
cp altlinux/%rtname-rt-count %buildroot%_libexecdir/%rtname/bin/rt-count
cp altlinux/%rtname-rt-escalate %buildroot%_libexecdir/%rtname/bin/rt-escalate

# fix permissions
find %buildroot%_libexecdir/%rtname/ -type d -print0 | xargs -r0 chmod 2755 --
find %buildroot%_libexecdir/%rtname/ -type f -print0 | xargs -r0 chmod 0644 --
find %buildroot%_libexecdir/%rtname/ -name '*.pm' -type f -print0 | xargs -r0 chmod 0755 --
find %buildroot%_libexecdir/%rtname/bin/ -type f -print0 |xargs -r0 chmod 0755 --
find %buildroot%_libexecdir/%rtname/sbin/ -type f -print0 |xargs -r0 chmod 0755 --
find %buildroot%wwwroot/%rtname -type d -print0 |xargs -r0 chmod 2755 --
find %buildroot%wwwroot/%rtname -type f -print0 |xargs -r0 chmod 0644 --
find %buildroot%_libexecdir/%rtname/local -type d -print0 |xargs -r0 chmod 2755 --
#this will be /usr/share/docs
find docs -type f -print0 |xargs -r0 chmod 0644 --

mkdir -p %buildroot%_var/log/%rtname
touch %buildroot%_var/log/%rtname/%rtname.log

# Remove win32 service
rm -f %buildroot/%_libexecdir/rt/bin/mason_handler.svc

# Replace /usr/local
sed -i "s|#!/usr/local/bin/perl|#!/usr/bin/perl|" %buildroot%_libexecdir/%rtname/bin/rt-count
sed -i "s|#!/usr/local/bin/perl|#!/usr/bin/perl|" %buildroot%_libexecdir/%rtname/bin/rt-escalate
sed -i "s|#!/usr/local/bin/speedy|#!/usr/bin/speedy|" %buildroot%_libexecdir/%rtname/bin/mason_handler.scgi

rm -f %wwwroot/%rtname/fonts/*ttf
ln -sf %_ttffontsdir/google-droid/DroidSans{,Fallback}.ttf %buildroot%wwwroot/%rtname/fonts/

#%pre
#/usr/sbin/groupadd -r %rtname


%post
#check for compliance
perl %_libexecdir/%rtname/sbin/rt-test-dependencies --with-mysql --with-fastcgi

cat <<EOF
	Congratulations. RT has been installed.

You must now configure RT by editing %siteconfig and %apacheconfig.

(You will definitely need to set RT's database password before continuing. Not doing
so could be very dangerous)

After that, you need to initialize RT's database by running:

%_libexecdir/%rtname/sbin/rt-setup-database --action init \ 
     --dba %mysql_dba --prompt-for-dba-password

If something goes wrong you can always drop everything, by executing:

%_libexecdir/%rtname/sbin/rt-setup-database --action drop \ 
     --dba %mysql_dba --prompt-for-dba-password

Look into these scripts and put them in the crontab:

%_libexecdir/%rtname/bin/rt-remind
%_libexecdir/%rtname/bin/rt-escalate
%_libexecdir/%rtname/bin/rt-count

Put these lines in the /etc/aliases and read the docs:

# RT aliases
support: "|%_libexecdir/%rtname/bin/rt-mailgate --queue 'General' --action correspond --url https://rt.example.com/"
support-comments: "|%_libexecdir/%rtname/bin/rt-mailgate --queue 'General' --action comment --url https://rt.example.com/"
#
    Go to the http://wiki.bestpractical.com/ for contribs and docs

EOF

%post postgresql

echo ""
echo "You must change database type in the config."
echo ""
echo "After that, you need to initialize RT's database by running"
echo ""
echo "%_libexecdir/%rtname/sbin/rt-setup-database --action init \ "
echo "     --dba %pgsql_dba --prompt-for-dba-password"
echo ""
echo "If something goes wrong you can always drop everything, by executing"
echo ""
echo "%_libexecdir/%rtname/sbin/rt-setup-database --action drop \ "
echo "     --dba %pgsql_dba --prompt-for-dba-password"
echo ""

#%%post oracle

#echo ""
#echo "You must change database type in the config."
#echo ""
#echo "After that, you need to initialize RT's database by running"
#echo ""
#echo "%_libexecdir/%rtname/sbin/rt-setup-database --action init \ "
#echo "     --dba %oracle_dba --prompt-for-dba-password"
#echo ""
#echo "If something goes wrong you can always drop everything, by executing"
#echo ""
#echo "%_libexecdir/%rtname/sbin/rt-setup-database --action drop \ "
#echo "     --dba %oracle_dba --prompt-for-dba-password"
#echo ""

%post sqlite

echo ""
echo "You must change database type in the config."
echo ""
echo "After that, you need to initialize RT's database by running"
echo ""
echo "%_libexecdir/%rtname/sbin/rt-setup-database --action init \ "
echo "     --dba %sqlite_dba --prompt-for-dba-password"
echo ""
echo "If something goes wrong you can always drop everything, by executing"
echo ""
echo "%_libexecdir/%rtname/sbin/rt-setup-database --action drop \ "
echo "     --dba %sqlite_dba --prompt-for-dba-password"
echo ""

%files
%doc etc/upgrade README README.Oracle COPYING docs UPGRADING.mysql UPGRADING
%_libexecdir/%rtname
%attr(3775,root,%webgrp) %dir %_var/log/%rtname
%attr(0664,root,%webgrp) %_var/log/%rtname/%rtname.log
%dir %_localstatedir/%rtname
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/cache
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/cache/mason_data
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/cache/mason_data/cache
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/cache/mason_data/etc
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/cache/mason_data/obj
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/cache/session_data
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/data
%attr(3775,root,%webgrp) %dir %_localstatedir/%rtname/data/gpg
%wwwroot/%rtname
%dir %_sysconfdir/%rtname
%attr(0640,root,%webgrp) %config(noreplace) %_sysconfdir/%rtname/RT_SiteConfig.pm
%attr(0644,root,%webgrp) %config %_sysconfdir/%rtname/RT_Config.pm
%attr(0644,root,%webgrp) %_sysconfdir/%rtname/acl*
%attr(0644,root,%webgrp) %_sysconfdir/%rtname/initialdata
%attr(0644,root,%webgrp) %_sysconfdir/%rtname/schema*
%exclude %apacheconfig
%exclude %apache2config

%files apache 
%attr(0640,root,%webgrp) %config(noreplace) %apacheconfig

%files apache2
%attr(0640,root,%webgrp) %config(noreplace) %apache2config

%files postgresql
#%%files oracle
%files sqlite

%changelog
