%define IF_ver_gt() %if "%(rpmvercmp '%1' '%2')" > "0"
%define IF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%define IF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"
%define IF_ver_lteq() %if "%(rpmvercmp '%2' '%1')" >= "0"
%define IF_ver_eq() %if "%(rpmvercmp '%1' '%2')" == "0"
%define IF_ver_not_gt() %if "%(rpmvercmp '%1' '%2')" <= "0"
%define IF_ver_not_gteq() %if "%(rpmvercmp '%1' '%2')" < "0"
%define IF_ver_not_lt() %if "%(rpmvercmp '%2' '%1')" <= "0"
%define IF_ver_not_lteq() %if "%(rpmvercmp '%2' '%1')" < "0"
%define IF_ver_not_eq() %if "%(rpmvercmp '%1' '%2')" != "0"

%ifarch %ix86
%set_verify_elf_method textrel=relaxed
%endif
%ifarch %arm
%set_verify_elf_method textrel=relaxed
%endif

%define rname ring-project
%define _libexecdir %prefix/libexec
%define builddir %_builddir/%name-%version
%define ring_sover 0
%define libring libring%ring_sover
%define ringclient_sover 1.0.0
%define libringclient libringclient%ringclient_sover

Name: ring-project
Version: 20180712
Release: alt1%ubt.1

Group: Networking/Instant messaging
Summary: SIP and IAX2 compatible softphone
Url: http://ring.cx/
License: GPLv3

PreReq(post,preun): alternatives >= 0.2
#Conflicts: sflphone sflphone-common
#Requires: %name-common >= %EVR

Source: %name-%version.tar
Patch1: alt-fix-linking.patch
Patch2: alt-pcre-include.patch

BuildRequires(pre): rpm-build-ubt
%IF_ver_gteq %ubt_id M90
BuildRequires: asio-devel
%endif
BuildRequires: cmake gcc-c++ glibc-devel autoconf-archive
BuildRequires: doxygen graphviz gtk-doc
BuildRequires: qt5-tools-devel
BuildRequires: chrpath
BuildRequires: libalsa-devel libdbus-c++-devel libgnutls-devel libgsm-devel
BuildRequires: libavdevice-devel libavformat-devel libswscale-devel libavutil-devel libavcodec-devel libavfilter-devel
BuildRequires: libssl-devel libgpg-error-devel libgcrypt-devel
BuildRequires: libnettle-devel libpcre-devel libpulseaudio-devel libsamplerate-devel libsndfile-devel libvpx-devel
BuildRequires: libspeexdsp-devel libswscale-devel libudev-devel libupnp-devel libuuid-devel jsoncpp-devel
BuildRequires: zlib-devel libopus-devel libspeex-devel ilbc-devel libmsgpack-devel libx264-devel libx265-devel libva-devel libvdpau-devel
BuildRequires: libyaml-cpp-devel yasm perl-Pod-Usage cppunit-devel libgmp-devel libexpat-devel
BuildRequires: evolution-data-server-devel libclutter-gtk3-devel libnotify-devel libpixman-devel
BuildRequires: libXdmcp-devel libpng-devel libXxf86vm-devel libappindicator-gtk3-devel libwebkit2gtk-devel libqrencode-devel
BuildRequires: libcanberra-gtk3-devel

%description
Ring is a Voice-over-IP software phone. We want it to be:
- user friendly (fast, sleek, easy to learn interface)
- professional grade (transfers, holds, optimal audio quality)
- fully compatible with Asterisk (SIP and IAX protocols)
- de-centralized call (P2P-DHT)
- customizable

As the SIP/audio daemon and the user interface are separate processes,
it is easy to provide different user interfaces. Ring comes with
various graphical user interfaces and even scripts to control the daemon from
the shell.

%package -n ring-daemon
Group: System/Servers
Summary: SIP and IAX2 compatible softphone daemon
%description -n ring-daemon
As the SIP/audio daemon and the user interface are separate processes,
it is easy to provide different user interfaces. Ring comes with
various graphical user interfaces and even scripts to control the daemon from
the shell.

%package -n ring-client-gnome
Summary: Ring client written in GTK+
Group: Networking/Instant messaging
%description -n ring-client-gnome
Ring-client-gnome is a Ring client written in GTK+. It uses libRingClient to
communicate with the Ring daemon and for all of the underlying models and their
logic. Ideally ring-client-gnome should only contain UI related code and any
wrappers necessary for interacting with libRingClient.

%package common
BuildArch: noarch
Summary: Common %name files
Group: System/Configuration/Other
Conflicts: ring-daemon < 3
Provides: ring-daemon-common = 4.1
Obsoletes: ring-daemon-common < 4.1
Provides: libringclient-common = 1.1
Obsoletes: libringclient-common < 1.1
%description common
Common %name files

%package -n %libring
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libring
%name library.

%package -n %libringclient
Group: System/Libraries
Summary: Ring client library
Requires: %name-common >= %EVR
%description -n %libringclient
Client library for GNU Ring.

%package devel
Group: Development/Other
Summary: Development files for %name
Provides: ring-daemon-devel = %version-%release
Provides: libringclient-devel = %version-%release
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-static
Group: Development/Other
Summary: Development files for %name
Requires: %name-devel
Provides: ring-daemon-devel-static = %version-%release
%description devel-static
The %name-devel package contains static libraries for
developing applications that use %name.

%prep
%setup -qn %name-%version
%patch1 -p1
%patch2 -p1

%build
%add_optflags %optflags_shared
mkdir -p daemon/contrib/native
pushd daemon/contrib/native
../bootstrap \
    --no-checksums \
    --disable-downloads \
    --disable-ogg \
    --disable-flac \
    --disable-vorbis \
    --disable-vorbisenc \
    --disable-speex \
    --disable-sndfile \
    --disable-speexdsp \
    --disable-gsm \
    --disable-natpmp \
    #
make list
make
popd
pushd daemon
./autogen.sh
%configure \
    --with-libilbc \
    --with-opus \
    --enable-video \
    --enable-ipv6 \
    --without-jack \
    CFLAGS="%optflags" \
    LDFLAGS="-Wl,-z,defs" \
    #
%make_build
popd

pushd lrc
%cmake \
    -DRING_BUILD_DIR=%builddir/daemon/src \
    -DENABLE_VIDEO=ON \
    -DCMAKE_BUILD_TYPE=Release \
    #
[ -e build ] || ln -s BUILD build
pushd BUILD
%make_build
popd
popd

pushd client-gnome
%cmake \
    -DLibRingClient_PROJECT_DIR=%builddir/lrc \
    -DGSETTINGS_LOCALCOMPILE=OFF \
    #
pushd BUILD
%make_build
popd
popd

%install
%makeinstall -C daemon
make install -C lrc/BUILD DESTDIR=%buildroot
make install -C client-gnome/BUILD DESTDIR=%buildroot

chrpath --delete %buildroot/%_libdir/ring/dring

# install alternatives
mkdir -p %buildroot/%_bindir/
rm -f %buildroot/%_bindir/ring{,.cx}
ln -s /bin/true %buildroot/%_bindir/ring.cx
ln -s ring.cx %buildroot/%_bindir/ring
#
echo >%buildroot/%_bindir/ring-client-dummy <<__EOF__
#!/bin/sh
echo "Ring not found" >&2
exit 1
__EOF__
chmod 0755 %buildroot/%_bindir/ring-client-dummy
#
install -d %buildroot/%_sysconfdir/alternatives/packages.d
cat > %buildroot/%_sysconfdir/alternatives/packages.d/%name <<__EOF__
%_bindir/ring.cx       %_bindir/ring-client-dummy      1
__EOF__
cat > %buildroot/%_sysconfdir/alternatives/packages.d/ring-client-gnome <<__EOF__
%_bindir/ring.cx       %_bindir/gnome-ring      10
__EOF__

%if "%_lib" == "lib64"
sed -i 's|/usr/lib|/usr/lib64|' %buildroot/usr/lib/cmake/LibRingClient/LibRingClientConfig.cmake
mkdir -p %buildroot/%_libdir
mv %buildroot/usr/lib/* %buildroot/%_libdir/
%endif

%find_lang lrc --with-qt
%find_lang ring-client-gnome

%files common
%_iconsdir/hicolor/*/apps/ring.*

%files -n ring-daemon
%doc daemon/AUTHORS daemon/COPYING daemon/README
%config %_sysconfdir/alternatives/packages.d/%name
%ghost %_bindir/ring
%_bindir/ring.cx
%_bindir/ring-client-dummy
%_libdir/ring/
%_datadir/dbus-1/services/cx.ring.*
%_datadir/ring/

%files -n ring-client-gnome -f ring-client-gnome.lang
%config %_sysconfdir/alternatives/packages.d/ring-client-gnome
%_bindir/gnome-ring
%_datadir/gnome-ring
%_desktopdir/gnome-ring.desktop
%_datadir/sounds/gnome-ring/
%_datadir/glib-2.0/schemas/cx.ring.*.gschema.xml

%files -n %libring
%doc daemon/AUTHORS daemon/COPYING daemon/README
%_libdir/libring.so.%ring_sover
%_libdir/libring.so.*

%files -n %libringclient -f lrc.lang
%doc lrc/COPYING
%_libdir/libringclient.so.%ringclient_sover
%_libdir/libringclient.so.*

%files devel
%_libdir/lib*.so
%_includedir/dring/
%_includedir/libringclient/
%_datadir/dbus-1/interfaces/cx.ring.Ring.*.xml
%_libdir/cmake/LibRingClient/
%_man1dir/dring.*

%files devel-static
#%_libdir/libring.a

%changelog
