# python-module-rpm overrides %%version
%define rpm_version 4.0.4

Name: rpm
Version: 4.0.4
Release: alt101.M80P.5.6

%define ifdef() %if %{expand:%%{?%{1}:1}%%{!?%{1}:0}}
%define get_dep() %(rpm -q --qf '%%{NAME} >= %%|SERIAL?{%%{SERIAL}:}|%%{VERSION}-%%{RELEASE}' %1 2>/dev/null || echo '%1 >= unknown')
%define def_with() %{expand:%%{!?_with_%{1}: %%{!?_without_%{1}: %%global _with_%{1} --with-%{1}}}}
%define def_without() %{expand:%%{!?_with_%{1}: %%{!?_without_%{1}: %%global _without_%{1} --without-%{1}}}}
%define if_with() %if %{expand:%%{?_with_%{1}:1}%%{!?_with_%{1}:0}}
%define if_without() %if %{expand:%%{?_without_%{1}:1}%%{!?_without_%{1}:0}}
%define _rpmlibdir %_prefix/lib/rpm

%def_with python
%def_with libelf
%def_without apidocs
%def_without db
%def_without build_topdir
%def_with selinux
%def_with profile
%def_disable default_priority_distbranch

# XXX enable at your own risk, CDB access to rpmdb isn't cooked yet.
%define enable_cdb create cdb

Summary: The RPM package management system
Summary(ru_RU.UTF-8): Менеджер пакетов RPM
License: GPL
Group: System/Configuration/Packaging
Url: http://www.rpm.org/

# http://git.altlinux.org/gears/r/rpm.git
Source: rpm-%version-%release.tar

Provides: %_rpmlibdir/macros.d, %_sysconfdir/%name/macros.d

# Can find pkgs by N-[E:]V-R (with Epoch!)
# (a feature present in rpm-4.13, but not in all releases of rpm-4.0.4):
Provides: RPMQ(EPOCH)
# Can find pkgs by N[-E:V-R]@BUILDTIME
Provides: RPMQ(BUILDTIME)
# Can find pkgs by N-E:V-R:DISTTAG[@T]
Provides: RPMQ(DISTTAG)


PreReq: lib%name = %version-%release, librpmbuild = %version-%release
PreReq: alt-gpgkeys, coreutils, /bin/sh

# Due to rpm*cmp utilities.
Conflicts: rpm-utils <= 0:0.9.10-alt1

%{?_with_python:BuildPreReq: python-devel}
%{?_with_apidocs:BuildPreReq: ctags doxygen}
%{?_with_libelf:BuildPreReq: libelf-devel-static}
%{?_with_selinux:BuildPreReq: libselinux-devel >= 2.0.96}
%{?_with_profile:BuildPreReq: coreutils >= 6.0}

BuildPreReq: automake >= 1.7.1, autoconf >= 2.53, libbeecrypt-devel-static >= 4.2.1
BuildPreReq: rpm >= 3.0.6-ipl24mdk, %_bindir/subst

# For debugedit.
BuildPreReq: elfutils-devel

# Automatically added by buildreq on Thu Apr 23 2009 and edited manually.
BuildRequires: bzlib-devel-static libdb4.7-devel-static libelf-devel-static liblzma-devel-static libpopt-devel-static python-devel zlib-devel-static

%package -n lib%name
Summary: Shared libraries required for applications which will manipulate RPM packages
Summary(ru_RU.UTF-8): Файлы, необходимые для разработки приложений, взаимодействующих с RPM-пакетами
License: GPL/LGPL
Group: System/Libraries
PreReq: zlib >= 1.1.4
PreReq: bzlib >= 1:1.0.2-alt2
PreReq: libpopt >= 1:1.7-alt3
PreReq: libdb4.7

%package -n librpmbuild
Summary: Shared library required for applications which will build RPM packages
Summary(ru_RU.UTF-8): Разделяемая библиотека для разработки приложений, собирающих RPM-пакеты
License: GPL/LGPL
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name-devel
Summary: Development files for applications which will manipulate RPM packages
Summary(ru_RU.UTF-8): Файлы, необходимые для разработки приложений, взаимодействующих с RPM-пакетами
License: GPL/LGPL
Group: Development/C
Provides: %name-devel = %version-%release
Obsoletes: %name-devel
Requires: lib%name = %version-%release, librpmbuild = %version-%release
Requires: libpopt-devel

%package -n lib%name-devel-static
Summary: Static libraries for developing statically linked applications which will manipulate RPM packages
Summary(ru_RU.UTF-8): Статические библиотеки, необходимые для разработки статических приложений, взаимодействующих с RPM-пакетами
License: GPL/LGPL
Group: Development/C
Requires: lib%name-devel = %version-%release
Requires: bzlib-devel-static, libbeecrypt-devel-static, libdb4.7-devel-static, libpopt-devel-static, zlib-devel-static

%package build
Summary: Scripts and executable programs used to build packages
Summary(ru_RU.UTF-8): Файлы, необходимые для установки SRPM-пакетов и сборки RPM-пакетов
License: GPL
Group: Development/Other
Obsoletes: spec-helper
PreReq: librpmbuild = %version-%release, %name = %version-%release
PreReq: shadow-utils
Requires: autoconf autoconf-common automake automake-common bison coreutils cpio
Requires: gcc gettext-tools glibc-devel gnu-config file kernel-headers libtool m4 make
Requires: procps psmisc sed service which
Requires: bash >= 0:3.1.17-alt4
Requires: bzip2 >= 1:1.0.2-alt4
Requires: xz
Requires: gzip >= 0:1.3.3-alt2
Requires: mktemp >= 1:1.3.1
Requires: patch >= 2.5
Requires: tar >= 0:1.13.22-alt1
Requires: %_bindir/subst
Requires: alternatives >= 0.3.2
Requires: elfutils >= 0.143-alt1
Requires: info-install >= 4.11
Requires: pkgconfig-reqprov pkgconfig-recursion
Requires: rpm-build-perl >= 0.76
Requires: rpm-build-python >= 0.31
Conflicts: rpm-build-tcl <= 0.2
Conflicts: rpm-build-mono <= 1.0
# Due to 'readelf --dyn-syms':
Requires: binutils >= 1:2.20.51.0.7

%package build-topdir
Summary: RPM package installation and build directory tree
Summary(ru_RU.UTF-8): Сборочное дерево, используемое для установки SRPM-пакетов и сборки RPM-пакетов
License: GPL
Group: Development/Other
PreReq: %name-build = %version-%release

%package static
Summary: Static version of the RPM package management system
Summary(ru_RU.UTF-8): Статическая версия менеджера пакетов RPM
License: GPL
Group: System/Configuration/Packaging
PreReq: %name = %version-%release

%description
The RPM Package Manager (RPM) is a powerful command line driven
package management system capable of installing, uninstalling,
verifying, querying, and updating software packages.  Each software
package consists of an archive of files along with information about
the package like its version, a description, etc.

%description -l ru_RU.UTF-8
RPM - это мощный неинтерактивный менеджер пакетов, используемый для сборки,
установки, инспекции, проверки, обновления и удаления отдельных программных
пакетов.  Каждый такой пакет состоит из набора файлов и информации о пакете,
включающей название, версию, описание пакета, и т.д.

%description -n lib%name
This package contains shared libraries required to run dynamically linked
programs manipulating with RPM packages and databases.

%description -n librpmbuild
This package contains shared library required to run dynamically linked
programs building RPM packages.

%description -n lib%name-devel
This package contains the RPM C library and header files.  These
development files will simplify the process of writing programs
which manipulate RPM packages and databases and are intended to make
it easier to create graphical package managers or any other tools
that need an intimate knowledge of RPM packages in order to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%description -n lib%name-devel-static
This package contains the RPM C library and header files.  These
development files will simplify the process of writing programs
which manipulate RPM packages and databases and are intended to make
it easier to create graphical package managers or any other tools
that need an intimate knowledge of RPM packages in order to function.

This package should be installed if you want to develop statically linked
programs that will manipulate RPM packages and databases.

%description build
This package contains scripts and executable programs that are used to
build packages using RPM.

%description build-topdir
This package contains RPM package installation and build directory tree.

%description static
This package contains statically linked version of the RPM program.

%if_with python
%package -n python-module-rpm
Version: %{rpm_version}_%__python_version
Summary: Python bindings for apps which will manipulate RPM packages
Summary(ru_RU.UTF-8): Интерфейс для разработки Python-приложений, взаимодействующих с RPM-пакетами
License: GPL/LGPL
Group: Development/Python
PreReq: lib%name = %rpm_version-%release
Requires: python = %__python_version
Provides: rpm-python = %{rpm_version}_%__python_version-%release
Obsoletes: rpm-python

%description -n python-module-rpm
This package contains a module which permits applications written in
the Python programming language to use the interface supplied by RPM
(RPM Package Manager) libraries.
%endif #with python

%package checkinstall
Summary: Run tests for %name immediately when this package is installed
Group: Other
BuildArch: noarch
Requires: %name
# rpminstall-tests-checkinstall first uses rpm-build to build packages,
# then tests how rpm installs them. Useful for testing rpm-build, too.
Requires: rpminstall-tests-checkinstall

%description checkinstall
%summary

%prep
%setup -n rpm-%rpm_version-%release

%build
_PRIORITY_DISTBRANCH=%{?!_disable_default_priority_distbranch:%{?disttag}}
_PRIORITY_DISTBRANCH="${_PRIORITY_DISTBRANCH#*:}" # skip the optional padding
case "$_PRIORITY_DISTBRANCH" in
*+*) _PRIORITY_DISTBRANCH="${_PRIORITY_DISTBRANCH%%+*}" ;;
*) _PRIORITY_DISTBRANCH= ;;
esac
[ -n "$_PRIORITY_DISTBRANCH" ] || _PRIORITY_DISTBRANCH='%%nil'
export _PRIORITY_DISTBRANCH

gettextize --force --quiet --no-changelog --symlink
install -pv -m0644 /usr/share/automake/mkinstalldirs .
autoreconf -fisv -I m4
# avoid extra build dependencies
export ac_cv_path___CPIO=/bin/cpio
export ac_cv_path___UNZIP=/usr/bin/unzip
export ac_cv_path___LZMA=/usr/bin/lzma
export ac_cv_path___XZ=/usr/bin/xz
export ac_cv_path___GPG=/usr/bin/gpg
export ac_cv_path___SSH=/usr/bin/ssh
export LDFLAGS="-L$PWD/stub"
%configure \
	%{?_with_python} %{?_without_python} \
	%{?_with_apidocs} %{?_without_apidocs} \
	%{?_with_db} %{?_without_db} \
	%{subst_with selinux} \
	--program-transform-name=

# create a stub libselinux.a so that -lselinux would work in -static mode
mkdir stub
ar cq stub/libselinux.a
ln -s %_libdir/libselinux.so stub/

set_c_cflags="$(sed -n 's/^CFLAGS = //p' lib/Makefile) -W -Wno-missing-prototypes -Wno-override-init %{!?_enable_debug:-O3} -fno-builtin-memcmp"
%make_build -C lib set.lo CFLAGS="$set_c_cflags"
%make_build

rpmquery -a --provides |fgrep '= set:' |sort >P
rpmquery -a --requires |fgrep '= set:' |sort >R
join -o 1.3,2.3 P R |shuf >setcmp-data

%if_with profile
rm lib/set.lo lib/librpm.la tools/setcmp.static
%make_build -C lib set.lo librpm.la CFLAGS="$set_c_cflags -fprofile-generate"
%make_build -C tools setcmp.static CFLAGS="$(sed -n 's/^CFLAGS = //p' tools/Makefile) -fprofile-generate"
./tools/setcmp <setcmp-data >/dev/null
./tools/setcmp.static <setcmp-data >/dev/null
ls -l lib/.libs/set.gcda lib/set.gcda
rm lib/set.lo lib/librpm.la tools/setcmp.static
%make_build -C lib set.lo CFLAGS="$set_c_cflags -fprofile-use"
%make_build
%else
./tools/setcmp <setcmp-data >/dev/null
./tools/setcmp.static <setcmp-data >/dev/null
%endif #with profile

%if_with apidocs
rm -rf apidocs
make apidocs
%endif #with apidocs

# check
lib/test-set

%install
%make_install DESTDIR='%buildroot' install
chmod a-w %buildroot%_usrsrc/RPM{,/RPMS/*}

# Save list of packages through cron.
#mkdir -p %buildroot%_sysconfdir/cron.daily
#install -p -m0750 scripts/%name.daily -T %buildroot%_sysconfdir/cron.daily/%name
#
#mkdir -p %buildroot%_sysconfdir/logrotate.d
#install -p -m0640 scripts/%name.log -T %buildroot%_sysconfdir/logrotate.d/%name

mkdir -p %buildroot{%_rpmlibdir/macros.d,%_sysconfdir/%name/macros.d}
touch %buildroot%_sysconfdir/%name/macros
cat << E_O_F > %buildroot%_sysconfdir/%name/macros.cdb
%{?enable_cdb:#%%__dbi_cdb	%enable_cdb}
E_O_F

mkdir -p %buildroot%_localstatedir/%name
for dbi in \
	Basenames Conflictname Dirnames Group Installtid Name Providename \
	Provideversion Removetid Requirename Requireversion Triggername \
	Sigmd5 Sha1header Filemd5s Packages \
	__db.001 __db.002 __db.003 __db.004 __db.005 __db.006 __db.007 \
	__db.008 __db.009
do
    touch "%buildroot%_localstatedir/%name/$dbi"
done
touch %buildroot%_localstatedir/%name/files-awaiting-filetriggers

# Prepare documentation.
bzip2 -9k CHANGES ||:
mkdir -p %buildroot%_docdir/%name-%rpm_version
install -p -m0644 CHANGES.bz2 CREDITS README README.ALT* \
	%buildroot%_docdir/%name-%rpm_version/
cp -a doc/manual %buildroot%_docdir/%name-%rpm_version/
rm -f %buildroot%_docdir/%name-%rpm_version/manual/{Makefile*,buildroot}
%if_with apidocs
cp -a apidocs/man/man3 %buildroot%_mandir/
cp -a apidocs/html %buildroot%_docdir/%name-%rpm_version/apidocs/
%endif #with apidocs

# rpminit(1).
install -pD -m0755 rpminit -T %buildroot%_bindir/rpminit
install -pD -m0644 rpminit.1 -T %buildroot%_man1dir/rpminit.1

# Valid groups.
install -p -m0644 GROUPS %buildroot%_rpmlibdir/

# buildreq ignore rules.
install -pD -m0644 rpm-build.buildreq -T %buildroot%_sysconfdir/buildreqs/files/ignore.d/rpm-build

chmod a+x scripts/find-lang
# Manpages have been moved to their own packages.
#./scripts/find-lang --with-man %name rpm2cpio --output %name.lang
RPMCONFIGDIR=./scripts ./scripts/find-lang %name rpm2cpio --output %name.lang

pushd %buildroot%_rpmlibdir
	for f in *-alt-%_target_os; do
		n=`echo "$f" |sed -e 's/-alt//'`
		[ -e "$n" ] || ln -s "$f" "$n"
	done
popd

ls -d %buildroot%_rpmlibdir/*-%{_target_os}* |
	grep -Fv /brp- |
	sed -e "s|^%buildroot|%%attr(-,root,%name) |g" >>%name.lang

%ifdef add_findreq_skiplist
# These shell libraries hopefully do not require anything special,
# but we want to keep the "rpm" package dependencies to bare minimum.
%add_findreq_skiplist %_rpmlibdir/functions
%add_findreq_skiplist %_rpmlibdir/find-package
%endif
# However, syntax check is still a good idea.
sh -n %buildroot%_rpmlibdir/functions
sh -n %buildroot%_rpmlibdir/find-package

%if "%_lib" == "lib"
if [ -s /lib/libc.so.6 -a -s /lib/libz.so.1 -a -s /lib/librt.so.1 -a -n "$(getconf LFS_CFLAGS)" ]; then
	readelf --wide --symbols /lib/libc.so.6 /lib/libz.so.1 /lib/librt.so.1 |
		sed -n 's/^[[:space:]]*[0-9]\+:[[:space:]]\+[0-9a-f]\+[[:space:]]\+[0-9]\+[[:space:]]\+FUNC[[:space:]]\+[^[:space:]]\+[[:space:]]\+DEFAULT[[:space:]]\+[0-9]\+[[:space:]]\+\([^@[:space:]]\+\)@\?.*/\1/p' |
		sort -u
fi > all-funcs
sed -r -n 's/^(.+)64(_.*|$)/\1\2/p' all-funcs |
	sort -u |
	egrep -v '^(wcs|str)' |
	comm -12 - all-funcs |
	LC_ALL=C sort -u \
	> %buildroot%_rpmlibdir/verify-elf-non-lfs-funcs.list
%endif

%pre
[ ! -L %_rpmlibdir/noarch-alt-%_target_os ] || rm -f %_rpmlibdir/noarch-alt-%_target_os ||:

%post
chgrp %name %_localstatedir/%name/[A-Z]*
[ -n "$DURING_INSTALL" -o -n "$BTE_INSTALL" ] ||
	%_rpmlibdir/pdeath_execute $PPID rpmdb -v --rebuilddb

# Invalidate apt cache, due to e.g. rpmlib(PayloadIsLzma).
if set /var/cache/apt/*.bin && [ -f "$1" ]; then
	%_rpmlibdir/pdeath_execute $PPID rm -f "$@"
fi
:

%files -n librpmbuild
%_libdir/librpmbuild-*.so

%define rpmattr %attr(755,root,%name)
%define rpmdirattr %attr(2755,root,%name) %dir
%define rpmdatattr %attr(644,root,%name)
%define rpmdbattr %attr(644,root,%name) %verify(not md5 size mtime) %ghost %config(missingok,noreplace)

%files -n lib%name
%rpmdirattr %_rpmlibdir
%rpmdatattr %_rpmlibdir/rpmrc
%rpmdatattr %_rpmlibdir/macros
%_libdir/librpm-*.so
%_libdir/librpmdb-*.so
%_libdir/librpmio-*.so

%files -n lib%name-devel
%_libdir/librpm.so
%_libdir/librpmdb.so
%_libdir/librpmio.so
%_libdir/librpmbuild.so
%_includedir/%name
%if_with apidocs
%_man3dir/*
%dir %_docdir/%name-%rpm_version
%_docdir/%name-%rpm_version/apidocs
%endif #with apidocs

%files -n lib%name-devel-static
%_libdir/*.a

%files -f %name.lang
%dir %_docdir/%name-%rpm_version
%_docdir/%name-%rpm_version/[A-Z]*
%_docdir/%name-%rpm_version/manual

#%config(noreplace,missingok) %_sysconfdir/cron.daily/%name
#%config(noreplace,missingok) %_sysconfdir/logrotate.d/%name

%rpmdirattr %_rpmlibdir/macros.d
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/macros.d
%config(noreplace,missingok) %_sysconfdir/%name/macros
%config(noreplace,missingok) %_sysconfdir/%name/macros.??*

%rpmdirattr %_localstatedir/%name
%rpmdbattr %_localstatedir/%name/Basenames
%rpmdbattr %_localstatedir/%name/Conflictname
%rpmdbattr %_localstatedir/%name/__db.0*
%rpmdbattr %_localstatedir/%name/Dirnames
%rpmdbattr %_localstatedir/%name/Filemd5s
%rpmdbattr %_localstatedir/%name/Group
%rpmdbattr %_localstatedir/%name/Installtid
%rpmdbattr %_localstatedir/%name/Name
%rpmdbattr %_localstatedir/%name/Packages
%rpmdbattr %_localstatedir/%name/Providename
%rpmdbattr %_localstatedir/%name/Provideversion
%rpmdbattr %_localstatedir/%name/Removetid
%rpmdbattr %_localstatedir/%name/Requirename
%rpmdbattr %_localstatedir/%name/Requireversion
%rpmdbattr %_localstatedir/%name/Sigmd5
%rpmdbattr %_localstatedir/%name/Sha1header
%rpmdbattr %_localstatedir/%name/Triggername
%rpmdbattr %_localstatedir/%name/files-awaiting-filetriggers

/bin/rpm
%_bindir/rpm
%_bindir/rpm2cpio
%_bindir/rpmdb
%_bindir/rpm[eiu]
%_bindir/rpmsign
%_bindir/rpmquery
%_bindir/rpmverify
%_bindir/rpminit
%_bindir/rpm*cmp

%rpmattr %_rpmlibdir/pdeath_execute
%rpmattr %_rpmlibdir/rpm[dikq]
%_rpmlibdir/rpm[euv]
%rpmdatattr %_rpmlibdir/rpmpopt*
%rpmdatattr %_rpmlibdir/GROUPS
%_prefix/lib/rpmpopt
%_prefix/lib/rpmrc

%rpmattr %_rpmlibdir/posttrans-filetriggers
%rpmattr %_rpmlibdir/0ldconfig.filetrigger

%rpmattr %_rpmlibdir/functions
%rpmattr %_rpmlibdir/find-package
%rpmdatattr %_rpmlibdir/.provides.sh

%_man1dir/rpminit.*
%_man8dir/rpm.*
%_man8dir/rpm2cpio.*

%files build
%config %_sysconfdir/buildreqs/files/ignore.d/*
%rpmattr %_bindir/gendiff
%_bindir/rpmbuild
%_bindir/relative
%_rpmlibdir/rpmt
%rpmattr %_rpmlibdir/rpmb
%rpmattr %_rpmlibdir/debugedit
%rpmattr %_rpmlibdir/debuginfo.*
%rpmattr %_rpmlibdir/dump_ld_config
%rpmattr %_rpmlibdir/filesize
%rpmattr %_rpmlibdir/relative
%rpmattr %_rpmlibdir/brp-alt
%rpmattr %dir %_rpmlibdir/brp.d
%rpmattr %_rpmlibdir/brp.d/*
%rpmattr %_rpmlibdir/*_files
%rpmattr %_rpmlibdir/cpp.*
%rpmattr %_rpmlibdir/is_elf_so_executable
%rpmattr %_rpmlibdir/ldd
%rpmattr %_rpmlibdir/rpm2cpio.sh
%rpmattr %_rpmlibdir/find-lang
%rpmattr %_rpmlibdir/find-provides
%rpmattr %_rpmlibdir/find-requires
%rpmattr %_rpmlibdir/find-debuginfo-files
%rpmattr %_rpmlibdir/find-scriptlet-requires
%rpmattr %_rpmlibdir/fixup-*
%rpmattr %_rpmlibdir/files.*
%rpmattr %config %_rpmlibdir/*-files.req.list
%rpmattr %_rpmlibdir/lib.*
%rpmattr %_rpmlibdir/pam.*
%rpmattr %_rpmlibdir/percolate
%rpmattr %_rpmlibdir/pkgconfig.*
%rpmattr %_rpmlibdir/pkgconfiglib.*
%rpmattr %_rpmlibdir/provided_symbols
%rpmattr %_rpmlibdir/rpmlib.*
%rpmattr %_rpmlibdir/shell.*
%rpmattr %_rpmlibdir/shebang.*
%rpmattr %_rpmlibdir/static.*
%rpmattr %_rpmlibdir/suggest_bpp
%rpmattr %_rpmlibdir/symlinks.*
%rpmattr %_rpmlibdir/tmpdir.sh
%rpmattr %_rpmlibdir/verify-elf
%rpmattr %_rpmlibdir/*.awk
# set-version helpers
%rpmattr %_rpmlibdir/mkset
%rpmattr %_rpmlibdir/setcmp
%if "%_lib" == "lib"
%rpmdatattr %_rpmlibdir/verify-elf-non-lfs-funcs.list
%endif

%_mandir/man?/gendiff.*
%_man8dir/rpmbuild.*

%if_with build_topdir
%files build-topdir
%attr(0755,root,%name) %dir %_usrsrc/RPM
%attr(0770,root,%name) %dir %_usrsrc/RPM/BUILD
%attr(2770,root,%name) %dir %_usrsrc/RPM/SPECS
%attr(2770,root,%name) %dir %_usrsrc/RPM/SOURCES
%attr(2775,root,%name) %dir %_usrsrc/RPM/SRPMS
%attr(0755,root,%name) %dir %_usrsrc/RPM/RPMS
%attr(2775,root,%name) %dir %_usrsrc/RPM/RPMS/*
%endif #with build_topdir

%if_with python
%files -n python-module-rpm
%_libdir/python*/site-packages/*module.so
%endif #with python

%files static
%_bindir/rpm.static
%_bindir/rpm2cpio.static

%files checkinstall

%changelog
