%define debug_package %nil

Name: rpm-build-mingw32
Version: 61
Release: alt1
Summary: MinGW RPM helper macros

Group: Development/Other
License: GPLv2+
Url: http://altlinux.org
BuildArch: noarch

Packager: Boris Savelev <boris@altlinux.org>

Source: COPYING
Source2: mingw32.prov.files.sh
Source3: mingw32.req.files.sh
Source4: mingw32-find-requires.sh
Source5: mingw32-find-provides.sh
Source6: mingw32-scripts.sh
Source8: Toolchain-mingw32.cmake

BuildRequires: rpm-macros-mingw32

Requires: rpm-macros-mingw32
Requires: mingw32-binutils >= 2.19

%description
These helper macros provide possibility to rebuild
by some Alt Linux Team Policy compatible way.
Macroses from Fedora.
http://fedoraproject.org/wiki/Packaging/MinGW

%prep
%setup -q -c -T
cp %SOURCE0 COPYING
sed 's/@VERSION@/%version/' < %SOURCE4 > mingw32-find-requires.sh

%build
# nothing

%install
mkdir -p %buildroot

mkdir -p %buildroot%_libexecdir
install -m 755 %SOURCE6 %buildroot%_libexecdir/mingw32-scripts

mkdir -p %buildroot%_bindir
pushd %buildroot%_bindir
for i in mingw32-configure mingw32-make mingw32-pkg-config mingw32-cmake; do
  ln -s %_libexecdir/mingw32-scripts $i
done
popd

# NB. NOT _libdir
mkdir -p %buildroot%_rpmlibdir
install -m 0755 mingw32-find-requires.sh %buildroot%_rpmlibdir/mingw32.req
install -m 0755 %SOURCE5 %buildroot%_rpmlibdir/mingw32.prov
install -m 0755 %SOURCE2 %buildroot%_rpmlibdir/mingw32.prov.files
install -m 0755 %SOURCE3 %buildroot%_rpmlibdir/mingw32.req.files

mkdir -p %buildroot%_datadir/mingw32
install -m 644 %SOURCE8 %buildroot%_datadir/mingw32/

%files
%doc COPYING
%_bindir/mingw32-configure
%_bindir/mingw32-make
%_bindir/mingw32-pkg-config
%_bindir/mingw32-cmake
%_libexecdir/mingw32-scripts
%_datadir/mingw32
%_rpmlibdir/mingw32.*

%changelog
