Name: rpm-build-python3
Version: 0.1.10.10
Release: alt1.M80P.1

Summary: RPM helper macros to rebuild python3 packages
License: GPL
Group: Development/Other

Source: %name-%version.tar
BuildArch: noarch

Requires: file >= 4.26-alt11
Conflicts: rpm-build < 4.0.4-alt100.91
# Since the .so handling code in python3.req.py with the help of
# objdump is borrowed from rpm-build, we borrow the dependency, too
# (in the form of a Conflicts not to encumber python3 users' envinronment;
# anyway, if the user is able to compile an .so, he would have got binutils):
Conflicts: binutils < 1:2.20.51.0.7

# We want that the following directory gets detected as a dep of the built python3 pkgs;
# this happens automatically of the packages that owns it is installed.
Requires: %_rpmlibdir/python3-site-packages-files.req.list
# (The lib64 variant must be owned by the same package; thus it must be detected as well.)

Conflicts: python3 < 3.5

AutoReqProv: yes, nopython

BuildRequires: python3-dev

%description
These helper macros provide possibility to build python3 modules.

%prep
%setup

%install
install -pD -m644 python3 %buildroot%_rpmmacrosdir/python3
install -pD -m644 python3.env %buildroot%_rpmmacrosdir/python3.env
install -pD -m644 python3.buildreq %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
install -pD -m755 python3.prov %buildroot%_rpmlibdir/python3.prov
install -pD -m755 python3.prov.py %buildroot%_rpmlibdir/python3.prov.py
install -pD -m755 python3.prov.files %buildroot%_rpmlibdir/python3.prov.files
install -pD -m755 python3.req %buildroot%_rpmlibdir/python3.req
install -pD -m755 python3.req.py %buildroot%_rpmlibdir/python3.req.py
install -pD -m755 python3.req.constraint.py %buildroot%_rpmlibdir/python3.req.constraint.py
install -pD -m755 python3.req.files %buildroot%_rpmlibdir/python3.req.files
install -pD -m755 python3.compileall.py %buildroot%_rpmlibdir/python3.compileall.py
install -pD -m755 brp-bytecompile_python3 %buildroot%_rpmlibdir/brp.d/096-bytecompile_python3.brp
# It's like brp.d/128-hardlink_pyo_pyc.brp from rpm-build (but for python3-3.5):
install -pD -m755 brp-hardlink_opt_pyc %buildroot%_rpmlibdir/brp.d/128-hardlink_opt_pyc.brp
install -pD -m755 brp-fix_python3_site-packages_location %buildroot%_rpmlibdir/brp.d/000-fix_python3_site-packages_location.brp
#install -pd -m755 %buildroot%python_tooldir/rpm-build
#install -pD -m644 bdist_altrpm.py %buildroot%_libdir/python%__python_version/distutils/command/bdist_altrpm.py
#install -pD -m755 tools/*py %buildroot%python_tooldir/rpm-build
#install -pd -m755 %buildroot%python_tooldir/rpm-build/find
#install -pD -m644 tools/find/*py %buildroot%python_tooldir/rpm-build/find
#install -pd -m755 %buildroot%_bindir

#ln -s `relative %buildroot%python_tooldir/rpm-build/imalyzer.py %buildroot%_bindir/` %buildroot%_bindir/imalyzer
#ln -s `relative %buildroot%python_tooldir/rpm-build/requires.py %buildroot%_bindir/` %buildroot%_bindir/py_requires
#ln -s `relative %buildroot%python_tooldir/rpm-build/provides.py %buildroot%_bindir/` %buildroot%_bindir/py_provides

#unset RPM_PYTHON

%check
rpm_builddir="$PWD"
pushd %buildroot/%_rpmlibdir
# It calls ./python3.req, therefore we've changed the CWD:
"$rpm_builddir"/test.sh
popd

%files
%_rpmmacrosdir/python3
%_rpmmacrosdir/python3.env
%_sysconfdir/buildreqs/files/ignore.d/%name
%_rpmlibdir/brp.d/096-bytecompile_python3.brp
%_rpmlibdir/brp.d/128-hardlink_opt_pyc.brp
%_rpmlibdir/brp.d/000-fix_python3_site-packages_location.brp
%_rpmlibdir/python3.compileall.py
%_rpmlibdir/python3.req
%_rpmlibdir/python3.req.py
%_rpmlibdir/python3.req.constraint.py
%_rpmlibdir/python3.req.files
%_rpmlibdir/python3.prov
%_rpmlibdir/python3.prov.py
%_rpmlibdir/python3.prov.files

%changelog
