Name: rpm-utils
Version: 0.9.21
Release: alt1

Summary: Utilities every rpm packager must have
License: GPLv2+
Group: Development/Other

Source: %name-%version.tar

Requires: getopt, time
Requires: rpm-build > 0:4.0.4-alt96.8, mktemp >= 1:1.3.1
# strace version that works
Requires: strace >= 4.11

# Automatically added by buildreq on Wed Mar 26 2008
BuildRequires: gcc-c++ librpm-devel

%description
This package contains following utilities:
+ filereq - generates list of file requires while running the program;
+ packageof - generates list of packages owning specified files;
+ packagereq - generates list of package requires while running the program;
+ buildreq - generates and adds/updates BuildRequires tag in specfiles;
+ rpmdups,rpmrdups - generates list of duplicated packages;
+ rpmvercmp, rpmevrcmp: package version comparators;
+ paste_changelog - pastes a whole ready piece to the top of a changelog;
+ stamp_spec - generates timestamp for rpm specfile changelog entry;
+ add_changelog - generates and adds changelog entry to rpm specfile;
+ compare_packages - generates lists of package sets and compares them;
+ cleanup_spec - attempts to cleanup rpm specfile;
+ rebuild_package - rebuilds source package keeping packager info unchanged;
+ rebuild_packages - rebuilds source packages using rebuild_package.

%prep
%setup

%build
%def_enable Werror
%make_build

%install
%makeinstall_std

%check
rpmquery -a --qf='%%{name}\n' |
	%buildroot%_datadir/buildreqs/optimize_package_list > out
grep -qs 'rpm-build' out
grep -qs 'librpm-devel' out
grep -qs 'gcc.*-c++' out

rm -f FAIL
rpmquery -a --qf '%%{name}\n' |while read n; do
	echo "$n" |
		%buildroot%_datadir/buildreqs/optimize_package_list > out
	[ "$n" = "$(cat out)" ] ||
		echo "$n -> $(cat out)" >> FAIL
done
if [ -s FAIL ]; then
	echo FAILED:
	cat FAIL
	exit 1
fi >&2

%files
%dir %_sysconfdir/buildreqs
%dir %_sysconfdir/buildreqs/*
%dir %_sysconfdir/buildreqs/files/*.d
%dir %_sysconfdir/buildreqs/packages/*.d
%config %_sysconfdir/buildreqs/files/*/*
%config %_sysconfdir/buildreqs/packages/essential*
%_bindir/*
%_datadir/buildreqs

%changelog
