%def_without bootstrap
%def_enable shared
%def_without valgrind
%def_enable rubygems
%define ruby_version 2.5.0
%define libdir %_prefix/lib/%name
%define includedir %_includedir
%define ridir %_datadir/ri
%define vendordir %libdir/vendor_%name

Name: ruby
%define lname lib%name
%define branch 2.5
%define ver_teeny 1
Version: %branch.%ver_teeny
Release: alt0.M80P.1
Summary: An Interpreted Object-Oriented Scripting Language
License: BSD (revised) or Ruby
Group: Development/Ruby
URL: http://www.%name-lang.org/
Source0: %name-%version.tar
Source1: update-ri-cache.rb
Source2: gems.tar
Source3: fakeruby.sh
Source4: miniruby.sh
Patch: %name-%version-%release.patch
Requires: %lname = %version-%release

%define obsolete() \
Provides: %1 = %version-%release \
Obsoletes: %1
%define mobsolete() \
%(for m in %*; do \
echo "Provides: %name-module-$m = %version-%release"; \
echo "Obsoletes: %name-module-$m"; \
done)

BuildRequires: doxygen groff-base libdb4-devel libffi-devel
BuildRequires: libgdbm-devel libncursesw-devel libreadline-devel libssl-devel
BuildRequires: zlib-devel libyaml-devel gcc-c++
%{?!_with_bootstrap:BuildRequires: ruby ruby-stdlibs rpm-build-ruby >= 1:0.1.3}
%{?_with_bootstrap:BuildRequires: ruby-miniruby-src = %ruby_version}
%{?_with_valgrind:BuildRequires: valgrind-devel}

%description
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains interpreter of object-oriented scripting language Ruby.


%package -n %lname
Summary: Ruby shared libraries
Group: System/Libraries
Provides: ruby(enumerator)

%description -n %lname
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby shared libraries.


%package -n %lname-devel
Summary: Files for compiling extension modules for Ruby
Group: Development/C
%{?_enable_shared:Requires: %lname = %version-%release}
Requires: rpm-build-%name >= 0.1.2

%description -n %lname-devel
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains files, necessary to make extension library for Ruby.


%package -n %lname-devel-static
Summary: Files for compiling extension modules for Ruby
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains static Ruby library needed for embedding Ruby.


%package -n %name-stdlibs
Summary: Standard Ruby libraries
Group: Development/Ruby
Requires: %lname = %version-%release
Provides: %name-libs = %version-%release
Provides: %name-json = 1.7.7
Obsoletes: %name-json
Provides: %name-minitest = 4.3.2
Obsoletes: %name-minitest
Provides: %name-racc-runtime = 1.4.6
Provides: %{name}gems = 2.6.13
%mobsolete English bigdecimal cgi curses date-time dbm debug digest dl drb e2mmap
%mobsolete erb etc fcntl fileutils gdbm iconv math misc net nkf open3 openssl
%mobsolete optparse patterns pty readline rexml rss sdbm shell socket stringio
%mobsolete strscan syslog tracer uri wait webrick xmlrpc yaml zlib
Provides: ruby(thread)
Requires: libyaml2 libgdbm libssl10 libcrypto10

%description -n %name-stdlibs
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains standard Ruby runtime libraries.


%package -n ri
Summary: Tool for display descriptions of built-in Ruby methods, classes, and modules
Group: Development/Ruby
BuildArch: noarch
Requires: %name-stdlibs = %version
%obsolete %name-tool-ri
Conflicts: rdoc <= 1.9.3-alt10

%description -n ri
ri is a command line tool that displays descriptions of built-in Ruby methods,
classes, and modules. For methods, it shows  you  the  calling sequence  and
a description. For classes and modules, it shows a synopsis along with a list
of the methods the class or module implements.


%package tools
Summary: Ruby tools
Group: Development/Ruby
BuildArch: noarch
Requires: %name-stdlibs = %version
Provides: gem = 2.6.13
Provides: %name-rake = 12.0.0
Provides: rake = 12.0.0
Obsoletes: %name-rake
Provides: rdoc = %version-%release
Obsoletes: rdoc < %version-%release
%obsolete %name-tool-rdoc
Provides: %{name}gems = 2.6.13
Obsoletes: %{name}gems

%description tools
Ruby tools: rake, rdoc, gem.

%package -n irb
Summary: Interactive Ruby Shell
Group: Development/Ruby
BuildArch: noarch
Requires: %name-stdlibs = %version
%obsolete %name-tool-irb

%description -n irb
irb is the REPL(read-eval&print loop) environment for Ruby programs.

%package doc-ri
Summary: Ruby ri documentatin
Group: Development/Documentation
BuildArch: noarch
AutoReq: no
AutoProv: no
Requires: ri = %version-%release

%description doc-ri
Ruby is an interpreted scripting language for quick and easy object-oriented
programming. It has many features for processing text files and performing system
management tasks (as in Perl). It is simple, straight-forward, and extensible.

This package contains Ruby documentation in ri format.

%if_without bootstrap
%package miniruby-src
Summary: Preprocessed miniruby sources
Group: Development/Ruby
BuildArch: noarch

%description miniruby-src
Contains generated files for preprocessed miniruby sources in patch
format. This files are required for ruby bootstrapping, especially
on different arches.
%endif

%prep
%setup -q
%patch -p1
tar xf %SOURCE2
# More strict shebang
sed -i '1s|^#!/usr/bin/env ruby|#!%_bindir/%name|' bin/*
# Remove $ruby_version from libs path
sed -i 's|/\$(ruby_version)||g;s|\(/%name/\)#{version}/|\1|g' tool/mkconfig.rb
sed -i 's|/\${ruby_version}||' template/%name.pc.in configure.ac
sed -i -r "s/File.join[[:blank:]]+(RbConfig::CONFIG\['ridir'\]),[[:blank:]]*version/\1/" lib/rdoc/ri/paths.rb
sed -i -r "/ridatadir[[:blank:]]*=/s/[[:blank:]]+CONFIG\['ruby_version'\],//" tool/rbinstall.rb
sed -i 's|[[:blank:]]*"/"RUBY_LIB_VERSION$||' version.c
# capi-docs
sed -i -e '/doc\/capi/s|"/capi|"/html/capi|' -e '/doc\/capi/s|doc/capi|&/html|' tool/rbinstall.rb
# put config.guess and config.sub from /usr/share/gnu-config
cp -a /usr/share/gnu-config/config.* tool

%build
%define ruby_arch %_target%([ -z "%_gnueabi" ] || echo "-eabi")
%autoreconf

my_configure() {
    %configure \
        %{subst_enable shared} \
        %{subst_with valgrind} \
        %{subst_enable rubygems} \
        --with-rubylibprefix=%libdir \
        --with-rubyhdrdir=%includedir \
        --with-sitearchdir=%libdir/site_ruby/%version/%ruby_arch \
        --with-vendorarchdir=%libdir/vendor_ruby/%version/%ruby_arch \
        --with-ridir=%ridir \
        --docdir=%_docdir/%name-%version \
        %{?ruby_version:--with-ruby-version=%ruby_version} \
        --with-compress-debug-sections=none \
        --disable-rpath "$@"
}

%if_with bootstrap
# *** 1st stage ***
# Build miniruby with preprocessed files from miniruby-src in a
# separate directory

cd %_builddir
cp -a %name-%version %name-%version-miniruby
cd %name-%version-miniruby
cp %SOURCE3 %SOURCE4 .

my_configure --with-baseruby=$PWD/fakeruby.sh
patch -p1 -l < %_datadir/%name-%version-miniruby/miniruby-src.patch
%make_build miniruby

# *** 2nd stage ***
# Build ruby with host miniruby frome 1st stage as baseruby
cd %_builddir/%name-%version
my_configure --with-baseruby=%_builddir/%name-%version-miniruby/miniruby.sh

%else #_with_bootstrap
my_configure

# Copy sources after configure, so that generated files for
# miniruby can be extracted later to facilitate bootstrapping.
cp -a %_builddir/%name-%version %_builddir/%name-%version-configured

# Build miniruby only, so that we can diff only minimal generated data.
%make_build miniruby

# Create diff for changed sources files with non-essential filtered out.
# For diff !0 exit status is normal.
pushd %_builddir
diff -Nur -x "*.o" -x miniruby -x "*.log" -x autom4te.cache \
    %name-%version-configured %name-%version > miniruby-src.patch || :
popd
%endif #_with_bootstrap

%make_build

%install
%makeinstall_std
echo "VENDOR_SPECIFIC=true" > %buildroot%vendordir/vendor-specific.rb
install -p -m 0755 %{S:1} %buildroot%_bindir/update-ri-cache
install -Dm 0755 %lname-static.a %buildroot%_libdir/%lname-static.a
ln -s %lname-static.a %buildroot%_libdir/%lname.a
mv %buildroot%_pkgconfigdir/%name{*,}.pc
install -d -m 0755 %buildroot%_docdir/%name-%version
install -p -m 0644 COPYING* LEGAL NEWS README* %buildroot%_docdir/%name-%version/

# RI filetrigger
install -d -m 0755 %buildroot%_rpmlibdir
cat > %buildroot%_rpmlibdir/%name-doc-ri.filetrigger <<__EOF__
#!/bin/sh

LC_ALL=C grep -qs '^%ridir/site/' || exit 0
exec %_bindir/update-ri-cache %ridir/site
__EOF__
chmod +x %buildroot%_rpmlibdir/%name-doc-ri.filetrigger

%define ruby_libdir %libdir
%define __ruby env LD_LIBRARY_PATH=%buildroot%_libdir RUBYLIB=%buildroot%libdir:%buildroot%libdir/site_ruby/%version/%ruby_arch %buildroot%_bindir/%name
export RUBYLIB=%buildroot%libdir:%buildroot%libdir/site_ruby/%version/%ruby_arch
export LD_LIBRARY_PATH=%buildroot%_libdir:%buildroot%_libdir/site_ruby/%version%ruby_arch

%add_findreq_skiplist %libdir/gems/*/gems/*/bin/*
%add_findreq_skiplist %libdir/*

%if_without bootstrap
mkdir -p %buildroot%_datadir/%name-%version-miniruby
mv %_builddir/miniruby-src.patch %buildroot%_datadir/%name-%version-miniruby/
%endif

%check
%make_build test

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/COPYING
%doc %_docdir/%name-%version/LEGAL
%doc %_docdir/%name-%version/NEWS
%doc %_docdir/%name-%version/README.*
%lang(ja) %doc %_docdir/%name-%version/*.ja
%_bindir/%name
%_man1dir/%name.*

%files -n %lname
%{?_enable_shared:%_libdir/*.so.*}

%files -n %lname-devel
%_pkgconfigdir/*
%includedir/*
%{?_enable_shared:%_libdir/*.so}

%files -n %lname-devel-static
%_libdir/*.a

%files stdlibs
%libdir

%files -n ri
%_bindir/update-ri-cache
%_bindir/ri
%_man1dir/ri.*
%exclude %_rpmlibdir/%name-doc-ri.filetrigger

%files tools
%_bindir/erb
%_bindir/gem
%_bindir/update_rubygems
%_bindir/rake
%_bindir/rdoc
%_man1dir/erb.*
#%_man1dir/rake.*

%files -n irb
%lang(ja) %doc doc/irb/*.ja
%_bindir/irb
%_man1dir/irb.*

%files doc-ri
%dir %ridir
%ridir/*

%if_without bootstrap
%files miniruby-src
%_datadir/%name-%version-miniruby/miniruby-src.patch
%endif

%changelog
