%define pkgname ffi

Name: ruby-%pkgname
Version: 1.9.18
Release: alt1.M80P.4

Summary: Ruby foreign function interface
Group: Development/Ruby
License: BSD
Url: https://github.com/ffi/ffi

Source: %pkgname-%version.tar
Patch1: %name-alt-fix-requires.patch

BuildRequires: libffi-devel libruby-devel ruby-tool-setup

%filter_from_requires \,^ruby(lib/ffi/.*generator),d

%description
A Ruby foreign function interface.

%package doc
Summary: Documentation files for %name
Group: Documentation
BuildArch: noarch

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%patch1 -p1
%update_setup_rb

sed -i -r '/^[[:blank:]]*Data_Get_Struct\(/s/^(([[:blank:]]*).*)((field) = layout->fields\[i\])(\).*)$/\2\3;\n\1\4\5/' \
	ext/ffi_c/StructLayout.c

%build
%ruby_config
%ruby_build

%install
%ruby_install
%rdoc lib/
# Remove unnecessary files
rm -f %buildroot%ruby_ri_sitedir/{Object/cdesc-Object.ri,cache.ri,created.rid}

%check
%ruby_test_unit -Ilib:test test

%files
%doc README.md LICENSE
%ruby_sitelibdir/*
%ruby_sitearchdir/*

%files doc
%ruby_ri_sitedir/*

%changelog
