Name:    ruby-gettext
Version: 3.2.9
Release: alt1.1.M80P.1

Summary: Native Language Support Library for Ruby
Group:   Development/Ruby
License: Ruby or LGPLv3+
Url: http://ruby-gettext.github.io/

BuildArch: noarch

Obsoletes: %name-cgi
Obsoletes: %name-erb
Provides: %name-cgi = %version-%release
Provides: %name-erb = %version-%release

BuildRequires: rpm-build-ruby ruby-locale ruby-racc-runtime ruby-rake ruby-tool-rdoc ruby-tool-setup
BuildRequires: ruby-test-unit

Requires: ruby-text

Source: gettext-%version.tar
Patch1: alt-gemspec.patch

%filter_from_requires /^ruby(mathn)$/d

%description
Ruby GetText Package is Native Language Support Library and Tools
which modeled after GNU gettext package.

Features:
 * Simple APIs(similar GNU gettext)
 * rgettext creates po-files from ruby scripts.
   The po-file is compatible to GNU gettext.
 * rmsgfmt creates a mo-file from a po-file.

%package utils
Summary: GetText utils
Group: Development/Ruby

%description utils
GetText utils

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup
%patch1 -p1
%update_setup_rb

%build
%ruby_config
%ruby_build

%install
%ruby_install
# Install gemspec
export rbVersion=`ruby -e "puts RbConfig::CONFIG[\"ruby_version\"]"`
install -Dm 0644 gettext.gemspec %buildroot%ruby_libdir/gems/$rbVersion/specifications/gettext.gemspec
%rdoc lib/

%find_lang rgettext

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find $RPM_BUILD_ROOT \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

# Remove unnecessary files
rm -f %buildroot%ruby_ri_sitedir/{Object/cdesc-Object.ri,Object/identify_comment-i.ri,cache.ri,created.rid}

# Install additional documentation
install -d %buildroot%_defaultdocdir/%name-doc-%version
cp -a samples ChangeLog* %buildroot%_defaultdocdir/%name-doc-%version

%check
%if %(rpmvercmp %version 2.0) < 0
cd test
%ruby_vendor -I../lib -e 'require "gettext/tools"; GetText.create_mofiles(:mo_root => "locale")'
find . -name 'test_*.rb' -print0 | xargs -r0 -n 1 %ruby_test_unit -I../lib -I./
%endif

%files
%doc README.md
%ruby_sitelibdir/*
%exclude %ruby_sitelibdir/gettext/tools
%exclude %ruby_sitelibdir/gettext/tools.rb
%ruby_libdir/gems/*/specifications/*.gemspec

%files -f rgettext.lang utils
%_bindir/*
%ruby_sitelibdir/gettext/tools
%ruby_sitelibdir/gettext/tools.rb

%files doc
%doc samples ChangeLog*
%ruby_ri_sitedir/GetText*

%changelog
