# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
# vim: set ft=spec: -*- rpm-spec -*-
%def_with tests

%define pkgname ruby-locale

Name: %pkgname
Version: 2.1.2
Release: alt2.M80P.4

Summary: Pure ruby library which provides basic APIs for localization
Group: Development/Ruby
License: MIT/Ruby
Url: http://rubyforge.org/projects/locale/

BuildArch: noarch

Source: %pkgname-%version.tar
Patch1: ruby-locale-2.0.6-alt-Do-not-call-locale-charmap-if-LC_-variables-unset.patch
Patch2: ruby-locale-2.0.6-alt-Fix-Array-vs-String-clash.patch
Patch3: alt-gemspec.patch
Patch4: ruby-locale-no_java.patch

BuildRequires: rpm-build-ruby ruby-stdlibs ruby-test-unit ruby-tool-rdoc ruby-tool-setup

%description
Ruby-Locale is the pure ruby library which provides basic and general
purpose APIs for localization.

It aims to support all environments which ruby works and all kind of
programs (GUI, WWW, library, etc), and becomes the hub of other
i18n/l10n libs/apps to handle major locale ID standards.

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%update_setup_rb

rm -f test/test_driver_jruby.rb
rm -f test/test_driver_win32.rb

%build
%ruby_config
%ruby_build

%install
%ruby_install
# Install gemspec
export rbVersion=`ruby -e "puts RbConfig::CONFIG[\"ruby_version\"]"`
install -Dm 0644 locale.gemspec %buildroot%ruby_libdir/gems/$rbVersion/specifications/locale.gemspec
%rdoc lib/

%check
%if_with tests
#%ruby_test_unit -Ilib:test test
%endif

%files
%doc README.rdoc
%ruby_sitelibdir/*
%exclude %ruby_sitelibdir/locale/driver/win32*.rb
%ruby_libdir/gems/*/specifications/*.gemspec

%files doc
%doc samples ChangeLog
%ruby_ri_sitedir/Locale*

%changelog
