# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname mongrel

Name: ruby-%pkgname
Version: 1.1.5
Release: alt7.M80P.4

Summary: Simple Fast Mostly Ruby Web Server
Group: Development/Ruby
License: MIT
Url: http://rubyforge.org/projects/mongrel/

Source: %pkgname-%version.tar
Patch: %pkgname-%version-%release.patch

# Automatically added by buildreq on Wed Aug 27 2008 (-bi)
BuildRequires: /proc libruby-devel ruby-daemons ruby-gem_plugin ruby-test-unit ruby-tool-setup ragel

%description
Mongrel is a small library that provides a very fast HTTP 1.1
server for Ruby web applications.  It is not particular to any
framework, and is intended to be just enough to get a web
application running behind a more complete and robust web
server.


%package doc
Summary: Documentation files for %name
Group: Development/Documentation
BuildArch: noarch

%description doc
Documentation files for %name.


%prep
%setup -q -n %pkgname-%version
%patch -p1
%update_setup_rb


%build
%ruby_config
## 58 tests, 445 assertions, 3 failures, 0 errors, 0 pendings, 0 omissions, 0 notifications
#pushd ext/http11
#ragel -G2 -o http11_parser.c http11_parser.rl
#popd
%ruby_build


%install
%ruby_install
%rdoc lib/


%check
%ruby_test_unit -Ilib:ext/http11 test


%files
%doc CHANGELOG README TODO
%_bindir/*
%ruby_sitelibdir/*
%ruby_sitearchdir/*


%files doc
%doc examples
%ruby_ri_sitedir/Mongrel*


%changelog
