%define Name Nokogiri
%define bname nokogiri
Name: ruby-%bname
Version: 1.8.0
Release: alt0.M80P.3
Summary: Ruby libraries for %Name (HTML, XML, SAX, and Reader parser)
Group: Development/Ruby
License: MIT/Ruby
URL: http://%bname.org
Source: %bname-%version.tar
Patch1: ignore-gems.patch

BuildPreReq: rpm-build-ruby
BuildRequires: ruby ruby-stdlibs libruby-devel ruby-racc ruby-tool-setup %_bindir/rexical
BuildRequires: libxml2-devel libxslt-devel java-devel ruby-pkg-config
#BuildRequires: db2latex-xsl xhtml1-dtds

%filter_from_requires /^ruby(.*\.jar)/d

%description
%Name parses and searches XML/HTML very quickly, and also has correctly
implemented CSS3 selector support as well as XPath support.
This package contanis Ruby libraries for Nokogiri.


%package -n %bname
Summary: HTML, XML, SAX, and Reader parser
Group: Development/Other
BuildArch: noarch
Requires: ruby >= 1.8
Requires: %name = %version-%release

%description -n %bname
%Name parses and searches XML/HTML very quickly, and also has correctly
implemented CSS3 selector support as well as XPath support.
This package contanis Ruby libraries for Nokogiri.


%package doc
Summary: Documentation for %Name
Group: Development/Documentation
BuildArch: noarch

%description doc
Documentation for %Name.


%prep
%setup -q -n %bname-%version
%patch1 -p1

DisableTest()
{
	local f="$1"

	shift
	while [ -n "$1" ]; do
		sed -i -r \
			-e "/^[[:blank:]]*def[[:blank:]]+test_$1[[:blank:]]*$/iif false" \
			-e "/^[[:blank:]]*def[[:blank:]]+test_$1[[:blank:]]*$/,/^[[:blank:]]*$/s/^[[:blank:]]*$/end\n&/" \
			"test/$f.rb"
		shift
	done
}

DisableTest test_convert_xpath multiple_filters
DisableTest css/test_nthiness last_of_type nth_last_of_type nth_of_type

%update_setup_rb


%build
%ruby_config -- --use-system-libraries
%ruby_build


%install
%ruby_install
%rdoc lib/
ls -d %buildroot%ruby_ri_sitedir/* | grep -v '/%Name$' | xargs rm -rf

%check
%ruby_test_unit -Ilib:ext:test test

%files
%ruby_sitelibdir/%bname
%ruby_sitelibdir/xsd
%ruby_sitelibdir/*.jar
%ruby_sitelibdir/*.rb
%ruby_sitearchdir/*


%files -n %bname
%_bindir/*


%files doc
%ruby_ri_sitedir/*


%changelog
