# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname racc

Name: ruby-%pkgname
Version: 1.4.6
Release: alt2.2.M80P.1
# It has to be newer than old ruby-module-racc-runtime 1.8 to workaround apt bug
Serial: 1

Summary: Ruby LALR(1) parser generator
Group: Development/Ruby
License: MIT/Ruby
Url: https://rubygems.org/gems/racc

Source: %pkgname-%version.tar
Patch: %pkgname-%version-%release.patch

BuildArch: noarch
# Automatically added by buildreq on Wed May 06 2009 (-bi)
BuildRequires: libruby-devel ruby-test-unit ruby-tool-setup

%description
Racc is an LALR(1) parser generator.
It is written in ruby itself, and generates ruby programs.

# Workaround for apt bugz
%package runtime
Summary: Runtime library for parser which is generated by Racc
Group: Development/Ruby
## Compatibility with old ruby
Provides: ruby-module-racc-runtime = %serial:%version-%release
Obsoletes: ruby-module-racc-runtime

%description runtime
Racc is an LALR(1) parser generator.
This package provides runtime library for parser which is generated
by Racc.

NOTE: Ruby 1.8.x comes with Racc runtime module.
You can run your parsers generated by racc 1.4.x out of the box.

%package doc
Summary: Documentation files for %name
Group: Documentation
BuildArch: noarch

%description doc
Documentation files for %name.

%prep
%setup -n %pkgname-%version
%patch -p1
%update_setup_rb

%build
%ruby_config
%ruby_build
%ruby_test_unit -Ilib:ext:test test/test_*.rb

%install
%ruby_install
%rdoc lib/

# The runtime is not packaged:
rm -rv %buildroot%ruby_sitearchdir
rm -v %buildroot%ruby_sitelibdir/racc/parser.rb

%files
%doc README.en.rdoc
%_bindir/racc
%_bindir/racc2y
%_bindir/y2racc
%ruby_sitelibdir/*
# %exclude %ruby_sitelibdir/racc/parser.rb

# %files runtime
# %dir %ruby_sitelibdir/racc
# %ruby_sitelibdir/racc/parser.rb
# %dir %ruby_sitearchdir/racc
# %ruby_sitearchdir/racc/cparse.so

%files doc
%doc sample
%ruby_ri_sitedir/Racc*

%changelog
